% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/remove.R, R/replace.R
\docType{methods}
\name{zero}
\alias{zero}
\alias{remove_zero}
\alias{remove_zero-method}
\alias{replace_zero}
\alias{replace_zero-method}
\alias{remove_zero,ANY-method}
\alias{replace_zero,matrix-method}
\alias{replace_zero,data.frame-method}
\title{Tools for Working With Zeros}
\usage{
remove_zero(x, ...)

replace_zero(x, ...)

\S4method{remove_zero}{ANY}(x, margin = 1, all = FALSE, na.rm = FALSE)

\S4method{replace_zero}{matrix}(x, value)

\S4method{replace_zero}{data.frame}(x, value)
}
\arguments{
\item{x}{An \R object (should be a \code{\link{matrix}} or a \code{\link{data.frame}}).}

\item{...}{Currently not used.}

\item{margin}{A length-one \code{\link{numeric}} vector giving the subscripts which the
function will be applied over (\code{1} indicates rows, \code{2} indicates columns).}

\item{all}{A \code{\link{logical}} scalar. If \code{TRUE}, only the rows/columns whose
values all meet the condition defined by \code{f} are considered. If \code{FALSE}
(the default), only rows/columns where at least one value validates the
condition defined by \code{f} are considered.}

\item{na.rm}{A \code{\link{logical}} scalar: should \code{NA} values be stripped before the
computation proceeds?}

\item{value}{A possible replacement value.}
}
\description{
\itemize{
\item \code{remove_zero()} remove rows/columns that contain zeros.
\item \code{replace_zero} replaces zeros.
}
}
\examples{
## Create a data matrix
X <- matrix(sample(1:10, 25, TRUE), nrow = 5, ncol = 5)

## Add zero
k <- sample(1:25, 3, FALSE)
X[k] <- 0
X

## Remove rows with zero
remove_zero(X, margin = 1)

## Replace zero
replace_zero(X, value = 1)
}
\seealso{
Other data cleaning tools: 
\code{\link{compact}()},
\code{\link{count}()},
\code{\link{detect}()},
\code{\link{discard}()},
\code{\link{empty}},
\code{\link{infinite}},
\code{\link{keep}()},
\code{\link{missing}},
\code{\link{remove_constant}()}
}
\author{
N. Frerebeau
}
\concept{data cleaning tools}
