% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{generate_uuid}
\alias{generate_uuid}
\title{UUID}
\usage{
generate_uuid(seed = NULL)
}
\arguments{
\item{seed}{A single \code{\link{integer}} specifying the seeds.
If \code{NULL} (the default) the seed will be re-initialized.}

\item{x}{A \code{\link{character}} string (UUID).}
}
\value{
A 36 characters long \code{\link{character}} string.
}
\description{
\code{generate_uuid} generates a universally unique identifier (UUID Version
4 and Variant 1).
}
\details{
As it relies on R's internal random number generators and so will suffer
 from the use of \code{\link{set.seed}} in a session, the seed is
 re-initialized during execution (unless \code{seed} is not \code{NULL}).
 To prevent any side effects, the random number generator (RNG) state is
 saved and restored when the function exits.
}
\seealso{
\link{set.seed}
}
\author{
N. Frerebeau
}
\keyword{internal}
