% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argonButton.R
\name{argonButton}
\alias{argonButton}
\title{Create a Boostrap 4 argon button}
\usage{
argonButton(name = NULL, status = "default", icon = NULL,
  size = NULL, block = FALSE, disabled = FALSE, outline = FALSE,
  toggle_modal = FALSE, modal_id = NULL)
}
\arguments{
\item{name}{Button label.}

\item{status}{Button color. See \url{https://demos.creative-tim.com/argon-design-system/docs/components/buttons.html}.}

\item{icon}{Button icon.}

\item{size}{Button size: NULL, "sm" or "lg".}

\item{block}{Whether the button fill its parent. FALSE by default.}

\item{disabled}{Whether to disable the button. FALSE by default.}

\item{outline}{Whether to outline the button. FALSE by default.}

\item{toggle_modal}{Whether to use th button for a modal. FALSE by default.}

\item{modal_id}{If toggle_modal is TRUE, nedd to provide the modal targeted.}
}
\description{
Build an argon button
}
\examples{
if(interactive()){
 library(argonR)
 argonButton(
  name = "Click me!",
  status = "danger",
  icon = "atom",
  size = "lg",
  toggle_modal = TRUE,
  modal_id = "modal1"
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
