% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tacf.R
\name{tacfplot}
\alias{tacfplot}
\title{Plots the theoretical autocorralation functions (tacfs) of one or more fits.}
\usage{
tacfplot(fits = list(), modes = "all", xlab = NULL, ylab = NULL,
  main = NULL, xlim = NULL, ylim = NULL, maxlag = 20, lag0 = FALSE,
  ...)
}
\arguments{
\item{fits}{A list of objects of class "arfima".}

\item{modes}{Either "all" or a vector of the same length as fits for which
the tacfs will be ploted.}

\item{xlab}{Optional.  Usually better to be generated by the function.}

\item{ylab}{Optional.  Usually better to be generated by the function.}

\item{main}{Optional.  Usually better to be generated by the function.}

\item{xlim}{Optional.  Usually better to be generated by the function.}

\item{ylim}{Optional.  Usually better to be generated by the function.}

\item{maxlag}{Optional. Used to limit the length of tacfs.  Highly
recommended to be a value from 20 - 50.}

\item{lag0}{Whether or not the lag 0 tacf should be printed.  Since this is
always 1 for all tacfs, recommended to be \code{TRUE}.  It is easier to see
the shape of the tacfs.}

\item{\dots}{Optional. Currently not used.}
}
\value{
NULL. However, there is a plot output.
}
\description{
Plots the theoretical autocorralation functions (tacfs) of one or more fits.
}
\examples{

\donttest{
set.seed(34577)
sim <- arfima.sim(500, model = list(theta = 0.9, phi = 0.5, dfrac = 0.4))
fit1 <- arfima(sim, order = c(1, 0, 1), cpus = 2, back=T)
fit2 <- arfima(sim, order = c(1, 0, 1), cpus = 2, lmodel = "g", back=T)
fit3 <- arfima(sim, order = c(1, 0, 1), cpus = 2, lmodel = "h", back=T)
fit1
fit2
fit3
tacfplot(fits = list(fit1, fit2, fit3), maxlag = 30)
}

}
\references{
Veenstra, J.Q. Persistence and Antipersistence:  Theory and
Software (PhD Thesis)
}
\seealso{
\code{\link{tacvf}}, \code{\link{plot.tacvf}}
}
\author{
JQ (Justin) Veenstra
}
\keyword{ts}
