% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asearch.R
\name{asearchLocal}
\alias{asearchLocal}
\title{Read Artifacts Given as a List of Tags}
\usage{
asearchLocal(patterns, repo = NULL)
}
\arguments{
\item{patterns}{A character vector of \code{Tags}. Only artifacts that 
contain all Tags are returned.}

\item{repo}{A character with path to local repository.}
}
\value{
This function returns a list of artifacts (by their values).
}
\description{
\code{asearchLocal} searches for artifacts that contain all specified \link{Tags}
and reads all of them from a local \link{Repository}. It's a wrapper around 
\link{searchInLocalRepo} and \link{loadFromLocalRepo}.
}
\details{
Function \code{asearchLocal} reads all artifacts that contain given list of \code{Tags}
from the selected Local Repository.
}
\section{Contact}{

 
Bug reports and feature requests can be sent to 
\href{https://github.com/pbiecek/archivist/issues}{https://github.com/pbiecek/archivist/issues}
}

\references{
Biecek P and Kosinski M (2017). "archivist: An R Package for Managing,
Recording and Restoring Data Analysis Results." _Journal of Statistical
Software_, *82*(11), pp. 1-28. doi: 10.18637/jss.v082.i11 (URL:
http://doi.org/10.18637/jss.v082.i11).
URL https://github.com/pbiecek/archivist
}
\seealso{
Other archivist: \code{\link{Repository}},
  \code{\link{Tags}}, \code{\link{\%a\%}},
  \code{\link{addHooksToPrint}}, \code{\link{addTagsRepo}},
  \code{\link{aformat}}, \code{\link{ahistory}},
  \code{\link{alink}}, \code{\link{aoptions}},
  \code{\link{archivist-package}},
  \code{\link{areadLocal}}, \code{\link{aread}},
  \code{\link{asearch}}, \code{\link{asession}},
  \code{\link{atrace}}, \code{\link{cache}},
  \code{\link{copyLocalRepo}},
  \code{\link{createLocalRepo}},
  \code{\link{createMDGallery}},
  \code{\link{deleteLocalRepo}},
  \code{\link{getRemoteHook}}, \code{\link{getTagsLocal}},
  \code{\link{loadFromLocalRepo}}, \code{\link{md5hash}},
  \code{\link{removeTagsRepo}}, \code{\link{restoreLibs}},
  \code{\link{rmFromLocalRepo}},
  \code{\link{saveToLocalRepo}},
  \code{\link{searchInLocalRepo}},
  \code{\link{setLocalRepo}},
  \code{\link{shinySearchInLocalRepo}},
  \code{\link{showLocalRepo}},
  \code{\link{splitTagsLocal}},
  \code{\link{summaryLocalRepo}},
  \code{\link{zipLocalRepo}}
}
\author{
Przemyslaw Biecek, \email{przemyslaw.biecek@gmail.com}
}
\concept{archivist}
