% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atrace.R
\name{atrace}
\alias{atrace}
\title{Add Tracing For All Objects Created By Given Function}
\usage{
atrace(FUN = "lm", object = "z")
}
\arguments{
\item{FUN}{name of a function to be traced (character)}

\item{object}{name of an object that should be traced (character)}
}
\description{
\code{atrace} add call to \link{saveToLocalRepo} at the end of a given function.
}
\details{
Function \code{atrace} calls the \link{trace} function.
}
\section{Contact}{

 
Bug reports and feature requests can be sent to 
\href{https://github.com/pbiecek/archivist/issues}{https://github.com/pbiecek/archivist/issues}
}

\examples{
# read the object from local directory
createLocalRepo("arepo_test", default=TRUE)
atrace("lm", "z")
lm(Sepal.Length~Sepal.Width, data=iris)
asearch("class:lm")
untrace("lm")
}
\references{
Biecek P and Kosinski M (2017). "archivist: An R Package for Managing,
Recording and Restoring Data Analysis Results." _Journal of Statistical
Software_, *82*(11), pp. 1-28. doi: 10.18637/jss.v082.i11 (URL:
http://doi.org/10.18637/jss.v082.i11).
URL https://github.com/pbiecek/archivist
}
\seealso{
Other archivist: \code{\link{Repository}},
  \code{\link{Tags}}, \code{\link{\%a\%}},
  \code{\link{addHooksToPrint}}, \code{\link{addTagsRepo}},
  \code{\link{aformat}}, \code{\link{ahistory}},
  \code{\link{alink}}, \code{\link{aoptions}},
  \code{\link{archivist-package}},
  \code{\link{areadLocal}}, \code{\link{aread}},
  \code{\link{asearchLocal}}, \code{\link{asearch}},
  \code{\link{asession}}, \code{\link{cache}},
  \code{\link{copyLocalRepo}},
  \code{\link{createLocalRepo}},
  \code{\link{createMDGallery}},
  \code{\link{deleteLocalRepo}},
  \code{\link{getRemoteHook}}, \code{\link{getTagsLocal}},
  \code{\link{loadFromLocalRepo}}, \code{\link{md5hash}},
  \code{\link{removeTagsRepo}}, \code{\link{restoreLibs}},
  \code{\link{rmFromLocalRepo}},
  \code{\link{saveToLocalRepo}},
  \code{\link{searchInLocalRepo}},
  \code{\link{setLocalRepo}},
  \code{\link{shinySearchInLocalRepo}},
  \code{\link{showLocalRepo}},
  \code{\link{splitTagsLocal}},
  \code{\link{summaryLocalRepo}},
  \code{\link{zipLocalRepo}}
}
\author{
Przemyslaw Biecek, \email{przemyslaw.biecek@gmail.com}
}
\concept{archivist}
