% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/createEmptyRepo.R
\name{createEmptyRepo}
\alias{createEmptyRepo}
\title{Create an Empty Repository in a Given Directory}
\usage{
createEmptyRepo(repoDir, force = TRUE)
}
\arguments{
\item{repoDir}{A character that specifies the directory for the Repository to be made.}

\item{force}{If \code{force = TRUE} function call forces to create \code{repoDir} directory if
it did not exist. Default set to \code{force = TRUE}.}
}
\description{
\code{createEmptyRepo} creates an empty \link{Repository} in a given directory in which archived artifacts will be stored.
}
\details{
At least one Repository must be initialized before using other functions from the \pkg{archivist} package.
When working in groups, it is highly recommended to create a Repository on a shared Dropbox/Git folder.

All artifacts desired to be archived are going to be saved in the local Repository, which is an SQLite
database stored in a file named \code{backpack}.
After calling \code{saveToRepo} function, every artifact will be archived in a \code{md5hash.rda} file.
This file will be saved in a folder (under \code{repoDir} directory) named
\code{gallery}. For every artifact, \code{md5hash} is a unique string of length 32 that comes out as a result of
\link[digest]{digest} function, which uses a cryptographical MD5 hash algorithm.

To learn more about artifacts visit \link[archivist]{archivist-package}.

Created \code{backpack} database is a useful and fundamental tool for remembering artifact's
\code{name}, \code{class}, \code{archiving date} etc. (that are remembered as \link{Tags}),
or for keeping artifact's \code{md5hash}.

Besides the \code{backpack} database, \code{gallery} folder is created in which all
artifacts will be archived.

After every \code{saveToRepo} call the database is refreshed, so an artifact is available
immediately in \code{backpack.db} database for other collaborators.
}
\examples{
\dontrun{
exampleRepoDir <- tempdir()
createEmptyRepo( repoDir = exampleRepoDir )

# check the state of an empty Repository

summaryLocalRepo(  repoDir = exampleRepoDir )
showLocalRepo( exampleRepoDir )

# creating a Repository in non existing directory

createEmptyRepo( "xyzdd234", force = TRUE )

# removing an example Repositories

deleteRepo( exampleRepoDir )
deleteRepo( "xyzdd234" )

rm( exampleRepoDir )
}
}
\author{
Marcin Kosinski, \email{m.p.kosinski@gmail.com}
}
\seealso{
Other archivist: \code{\link{Repository}};
  \code{\link{Tags}}; \code{\link{\%a\%}};
  \code{\link{addTagsRepo}}; \code{\link{ahistory}},
  \code{\link{print.ahistory}};
  \code{\link{archivist-package}}; \code{\link{aread}};
  \code{\link{asearch}}; \code{\link{cache}};
  \code{\link{copyGithubRepo}},
  \code{\link{copyLocalRepo}}; \code{\link{deleteRepo}};
  \code{\link{getTagsGithub}}, \code{\link{getTagsLocal}};
  \code{\link{loadFromGithubRepo}},
  \code{\link{loadFromLocalRepo}}; \code{\link{md5hash}};
  \code{\link{multiSearchInGithubRepo}},
  \code{\link{multiSearchInLocalRepo}},
  \code{\link{searchInGithubRepo}},
  \code{\link{searchInLocalRepo}};
  \code{\link{rmFromRepo}}; \code{\link{saveSetToRepo}};
  \code{\link{saveToRepo}}; \code{\link{setGithubRepo}},
  \code{\link{setLocalRepo}};
  \code{\link{shinySearchInLocalRepo}};
  \code{\link{showGithubRepo}},
  \code{\link{showLocalRepo}};
  \code{\link{summaryGithubRepo}},
  \code{\link{summaryLocalRepo}};
  \code{\link{zipGithubRepo}}, \code{\link{zipLocalRepo}}
}

