% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-category-details.R
\name{category_details}
\alias{category_details}
\title{Get the category details for a category ID.}
\usage{
category_details(
  category_id,
  icon = NULL,
  language = NULL,
  token = arc_token(),
  .progress = TRUE
)
}
\arguments{
\item{category_id}{Default \code{NULL}. A character vector which filters places to those that match the category IDs.}

\item{icon}{Default \code{NULL}. Must be one of \code{"svg"}, \code{"png"} \code{"cim"}. Determines whether icons are returned and the type of icon to use with a place or category.}

\item{language}{Optional case-sensitive parameter to specify the preferred language to.}

\item{token}{an object of class \code{httr2_token} as generated by \code{\link[arcgisutils:auth_code]{auth_code()}}
or related function}

\item{.progress}{Default \code{TRUE}. Whether a progress bar should be provided.}
}
\value{
A \code{data.frame} with columns:
\itemize{
\item \code{category_id}
\item \code{full_label}: a list of character vectors
\item \code{icon_url}: a character vector of the URL to an icon, if available
\item \code{parents}: a list of character vectors indicating the parent category ID
}
}
\description{
The \verb{/categories/\{categoryId\}} request returns all the groups to which the category belongs. You must supply a category ID to use this request. Note: Query parameters are case-sensitive.
}
\details{
\subsection{Language Codes}{

The language codes use the CLDR (Common Locale Data Repository) format string that uses a two letter language code (e.g. "fr" for French) optionally followed by a two letter country code (e.g. "fr-CA" for French in Canada).

If an unsupported language code is used, then the service will attempt to fall-back to the closest available language. This is done by stripping regional and extension subtags to find a known language code. For example, French Canadian (fr-CA) is unsupported so this falls back to French fr.

Should the fallback fail, then the service will return category names in the default language en for English.
}
}
\examples{
\dontrun{
categories <- c(
  "12015", "11172", "15015", "19027", "13309", "16069", "19004",
  "13131", "18046", "15048"
)
category_details(categories)
}
}
\references{
\href{https://developers.arcgis.com/rest/places/categories-category-id-get}{API Documentation}
}
