% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arc-read.R
\name{arc_read}
\alias{arc_read}
\title{Read an ArcGIS FeatureLayer, Table, or ImageServer}
\usage{
arc_read(
  url,
  col_names = TRUE,
  col_select = NULL,
  n_max = getOption("arcgislayers.n_max", default = 10000),
  name_repair = "unique",
  crs = NULL,
  ...,
  fields = NULL,
  token = arc_token()
)
}
\arguments{
\item{url}{The url of the remote resource. Must be of length one.}

\item{col_names}{Default \code{TRUE}. If \code{TRUE}, use the default column names for
the feature. If \code{col_names} is a character vector with the same length as
the number of columns in the layer, the default names are replaced with the
new names. If \code{col_names} has one fewer name than the default column names,
the existing sf column name is retained. If \code{col_names} is the string
\code{"alias"}, names are set to match the alias names for the layer, if available.}

\item{col_select}{Default \code{NULL}. A character vector of the field names to be
returned. By default, all fields are returned.}

\item{n_max}{Defaults to 10000 or an option set with
\verb{options("arcgislayers.n_max" = <max records>)}. Maximum number of records
to return.}

\item{name_repair}{Default \code{"unique"}. See \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}} for
details. If \code{name_repair = NULL}, names are set directly.}

\item{crs}{the spatial reference to be returned. If the CRS is different than
the CRS for the input \code{FeatureLayer}, a transformation will occur
server-side. Ignored if x is a \code{Table}.}

\item{...}{Additional arguments passed to \code{\link[=arc_select]{arc_select()}} if URL is a
\code{FeatureLayer} or \code{Table} or \code{\link[=arc_raster]{arc_raster()}} if URL is an \code{ImageLayer}.}

\item{fields}{a character vector of the field names that you wish to be
returned. By default all fields are returned.}

\item{token}{your authorization token.}
}
\value{
An sf object, a \code{data.frame}, or an object of class \code{SpatRaster}.
}
\description{
\code{\link[=arc_read]{arc_read()}} combines the functionality of \code{\link[=arc_open]{arc_open()}} with \code{\link[=arc_select]{arc_select()}}
or \code{\link[=arc_raster]{arc_raster()}} to read an ArcGIS \code{FeatureLayer}, \code{Table}, or \code{ImageServer} to an
\code{sf} or \code{SpatRaster} object. Optionally, set, check, or modify
names for the returned data frame or sf object using the \code{col_names} and
\code{name_repair} parameters.
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\dontrun{
  furl <- "https://sampleserver6.arcgisonline.com/arcgis/rest/services/Census#' /MapServer/3"

  # read entire service
  arc_read(furl)

  # apply tolower() to column names
  arc_read(url, name_repair = tolower)

  # use paste0 to prevent CRAN check NOTE
  furl <- paste0(
    "https://sampleserver6.arcgisonline.com/arcgis/rest/services/",
    "EmergencyFacilities/FeatureServer/0"
  )

 # use field aliases as column names
 arc_read(furl, col_names = "alias")

 # read an ImageServer directly
 img_url <- "https://landsat2.arcgis.com/arcgis/rest/services/Landsat/MS/ImageServer"

 arc_read(
   img_url,
   width = 100, height = 100,
   xmin = -71, ymin = 43,
   xmax = -67, ymax = 47.5,
   bbox_crs = 4326
 )

}
}
