% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\docType{data}
\name{rowley2019}
\alias{rowley2019}
\title{Soil Morphologic, Geochemical, and Mineralogy Data from Rowley et al. 2019.}
\format{
A \code{SoilProfileCollection} object:

site-level attributes \describe{ \item{id}{profile ID} \item{group}{profile
group} }

horizon-level attributes \describe{ \item{sample_id}{sample ID}
\item{name}{horizon name} \item{pH}{pH} \item{Al_exch}{cmol(+) / kg,
exchangeable Al} \item{Ca_exch}{cmol(+) / kg, exchangeable Ca}
\item{CEC_sum}{cmol(+) / kg, cation exchange capacity calculated as the sum
of exchangeable cations, not including H+}
\item{Ca_exch_saturation}{percent} \item{Al_exch_saturation}{percent}
\item{TON}{percent, total nitrogen} \item{SOC}{percent, soil organic carbon}
\item{C_to_N}{carbon to nitrogen ratio} \item{Alo}{g/kg, oxalate-extractable
Al} \item{Feo}{g/kg, oxalate-extractable Fe} \item{Ald}{g/kg,
dithionite-extractable Al} \item{Fed}{g/kg, dithionite-extractable Fe}
\item{Feo_Fed}{Fe_o to Fe_d ratio} \item{id}{profile ID} \item{top}{horizon
top (cm)} \item{bottom}{horizon bottom (cm)} \item{Al}{g/kg by x-ray
fluorescence} \item{Ca}{g/kg by x-ray fluorescence} \item{Cr}{g/kg by x-ray
fluorescence} \item{Fe}{g/kg by x-ray fluorescence} \item{K}{g/kg by x-ray
fluorescence} \item{Mg}{g/kg by x-ray fluorescence} \item{Mn}{g/kg by x-ray
fluorescence} \item{Na}{g/kg by x-ray fluorescence} \item{Ni}{g/kg by x-ray
fluorescence} \item{P}{g/kg by x-ray fluorescence} \item{Si}{g/kg by x-ray
fluorescence} \item{Ti}{g/kg by x-ray fluorescence}
\item{Phyllosilicates}{percent by x-ray diffraction spectra}
\item{Quartz}{percent by x-ray diffraction spectra}
\item{K_Feldspar}{percent by x-ray diffraction spectra}
\item{Na_Plagioclase}{percent by x-ray diffraction spectra}
\item{Goethite}{percent by x-ray diffraction spectra}
\item{Unidentified}{percent by x-ray diffraction spectra}
\item{CCE_Total}{percent} \item{CCE_Reactive}{percent}
\item{Reactive_carbonate}{percent} \item{Sand}{percent <2um}
\item{Silt}{percent 2-50um} \item{Clay}{percent 50-2000um}

\item{CaH2O}{Milliq ex: grams of Ca per kilogram of dry soil (g kg-1)}
\item{Ca2MKCl}{2M KCl: grams of Ca per kilogram of dry soil (g kg-1)}
\item{CaNa2EDTA}{0.05 M Na2EDTA: grams of Ca per kilogram of dry soil (g
kg-1)} \item{CaCuCl2}{0.5 M CuCl2: grams of Ca per kilogram of dry soil (g
kg-1)}

\item{hzID}{horizon ID} }
}
\usage{
data(rowley2019)
}
\description{
Data from Table 1 and Supplementary Tables 1 and 2 from "A cascading
influence of calcium carbonate on the biogeochemistry and pedogenic
trajectories of subalpine soils, Switzerland".
}
\examples{

library(lattice)

# load data
data('rowley2019')

# check first 5 rows and 10 columns of horizon data
horizons(rowley2019)[1:5, 1:10]

# check site data
site(rowley2019)

# graphical summary
par(mar=c(1,1,3,1))
plotSPC(rowley2019, color='Feo_Fed', name='name', cex.names=0.85)

plotSPC(rowley2019, color='Ca_exch', name='name', cex.names=0.85)

# grouped plot
groupedProfilePlot(rowley2019, groups = 'group', color='Ca_exch',
name='name', cex.names=0.85, group.name.offset = -10)

# aggregate over 1cm slices, for select properties
a <- slab(rowley2019, group ~ Reactive_carbonate + Ca_exch + pH + K_Feldspar + Na_Plagioclase + Al)

# plot styling
tps <- list(superpose.line=list(lwd=2, col=c('royalblue', 'firebrick')))

# make the figure
xyplot(top ~ p.q50 | variable, data=a, ylab='Depth', groups=group,
       main='', as.table=TRUE,
       xlab='median bounded by 25th and 75th percentiles',
       lower=a$p.q25, upper=a$p.q75, ylim=c(55,-5),
       panel=panel.depth_function,
       prepanel=prepanel.depth_function,
       cf=a$contributing_fraction,
       alpha=0.33, sync.colors=TRUE,
       scales=list(x=list(relation='free', alternating=1)),
       par.settings=tps,
       auto.key=list(columns=2, lines=TRUE, points=FALSE),
       strip=strip.custom(bg=grey(0.9))
)


}
\references{
Mike C. Rowley, Stephanie Grand, Thierry Adatte, Eric P.
Verrecchia, Cascading influence of calcium carbonate on the biogeochemistry and
pedogenic trajectories of subalpine soils), Switzerland, Geoderma, 2019,
114065, ISSN 0016-7061, \doi{10.1016/j.geoderma.2019.114065}.
}
\keyword{datasets}
