% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SoilProfileCollection-setters.R
\docType{methods}
\name{restrictions<-}
\alias{restrictions<-}
\alias{restrictions<-,SoilProfileCollection-method}
\title{Add data to the restrictions slot}
\usage{
restrictions(object) <- value
}
\arguments{
\item{object}{A SoilProfileCollection}

\item{value}{An object inheriting \code{data.frame}}
}
\description{
Restrictions data in an object inheriting from \code{data.frame} can easily be added via merge (LEFT JOIN). There must be one or more same-named profile ID columns on the left and right hand side to facilitate the join: \code{restrictions(spc) <- newdata}.
}
\examples{

# load test data
data(sp2)

# promote to SPC
depths(sp2) <- id ~ top + bottom

# assign abrupt textural change to a profile
newdata <- data.frame(id = c("hon-21"),
                      restrkind = "abrupt textural change",
                      restrdep = 46)

# do left join
restrictions(sp2) <- newdata

# inspect site table: newvalue TRUE only for horizons
#  with top depth equal to zero
restrictions(sp2)

}
