% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soilColorIndices.R
\name{harden.rubification}
\alias{harden.rubification}
\title{Harden (1982) Rubification}
\usage{
harden.rubification(hue, chroma, hue_ref, chroma_ref)
}
\arguments{
\item{hue}{A character vector containing Munsell hues (e.g. "7.5YR")}

\item{chroma}{A numeric vector containingMunsell chromas}

\item{hue_ref}{A character vector containing Munsell hue(s) (e.g. "10YR") for reference material}

\item{chroma_ref}{A numeric vector containing Munsell chroma(s) for reference material}
}
\value{
A numeric vector reflecting horizon redness increase relative to a reference (e.g. parent) material.
}
\description{
Calculate Rubification component of Profile Development Index after Harden (1982) "A quantitative index of soil development from field descriptions: Examples from a chronosequence in central California". Accepts vectorized inputs for hue, value and chroma to produce vector output. In Harden (1982) rubification is calculated relative to a reference parent material. Several other non-color components are normalized relative to a maximum value and summed to obtain the overall Profile Development Index.
}
\author{
Andrew G. Brown.
}
