% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info.R
\name{search_apple}
\alias{search_apple}
\title{Apple Store Search}
\usage{
search_apple(
  term,
  country = NULL,
  media = NULL,
  entity = NULL,
  attribute = NULL,
  limit = NULL,
  lang = c("en_us", "ja_jp"),
  explicit = c("Yes", "No")
)
}
\arguments{
\item{term}{The URL-encoded text string you want to search for. For example: \code{jack+johnson}.
If using a vector it will search for all terms in one search.}

\item{country}{The two-letter country code for the store you want to search.
For a list of country codes see \url{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2}}

\item{media}{\code{Optional} The media type you want to search for. For example: movie. The default is all.}

\item{entity}{\code{Optional} The type of results you want returned, relative to the specified media type.}

\item{attribute}{\code{Optional}    The attribute you want to search for in the stores, relative to the specified
media type. For example, if you want to search for an artist by name specify
\code{entity=allArtist&attribute=allArtistTerm}. In this example, if you search for term=maroon, iTunes
returns "Maroon 5" in the search results, instead of all artists who have ever recorded a song with the
word "maroon" in the title.}

\item{limit}{\code{Optional} The number of search results you want the iTunes Store to return between 1 and 200.
The default is 50.}

\item{lang}{\code{Optional} The language, English or Japanese, you want to use when returning search results.}

\item{explicit}{\code{Optional} A flag indicating whether or not you want to include explicit content
in your search results.}
}
\value{
A \code{data.frame} of any results that match the iTunes database.

If there were no successful results then it will return \code{NULL}.
}
\description{
Using Apple's iTunes API, will find any content available from Apple based on a given search term.
}
\examples{
# Search for all Jack Johnson audio and video content
search_apple(term = "jack johnson")

# To search for all Jack Johnson audio and video content and return only the first 25 items
search_apple(term = "jack johnson", limit = 25)

}
\seealso{
\url{https://affiliate.itunes.apple.com/resources/documentation/itunes-store-web-service-search-api/}
}
