% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_mdcevInside.R
\name{apollo_mdcevInside}
\alias{apollo_mdcevInside}
\title{Calculates MDCEV likelihoods without an outside good.}
\usage{
apollo_mdcevInside(
  V,
  alternatives,
  alpha,
  gamma,
  sigma,
  cost,
  avail,
  continuousChoice,
  budget,
  functionality,
  minConsumption = NA,
  rows = "all",
  componentName = "MDCEV"
)
}
\arguments{
\item{V}{Named list. Utilities of the alternatives. Names of elements must match those in argument 'alternatives'.}

\item{alternatives}{Character vector. Names of alternatives, elements must match the names in list 'V'.}

\item{alpha}{Named list. Alpha parameters for each alternative. As many elements as alternatives.}

\item{gamma}{Named list. Gamma parameters for each alternative. As many elements as alternatives.}

\item{sigma}{Numeric scalar. Scale parameter of the model extreme value type I error.}

\item{cost}{Named list of numeric vectors. Price of each alternative. One element per alternative, each one as long as the number of observations or a scalar. Names must match those in \code{alternatives}.}

\item{avail}{Named list. Availabilities of alternatives, one element per alternative. Names of elements must match those in argument 'alternatives'. Value for each element can be 1 (scalar if always available) or a vector with values 0 or 1 for each observation. If all alternatives are always available, then user can just omit this argument.}

\item{continuousChoice}{Named list of numeric vectors. Amount of consumption of each alternative. One element per alternative, as long as the number of observations or a scalar. Names must match those in \code{alternatives}.}

\item{budget}{Numeric vector. Budget for each observation.}

\item{functionality}{Character. Can take different values depending on desired output.
\itemize{
  \item "estimate" Used for model estimation.
  \item "prediction" Used for model predictions.
  \item "validate" Used for validating input.
  \item "zero_LL" Used for calculating null likelihood.
  \item "conditionals" Used for calculating conditionals.
  \item "output" Used for preparing output after model estimation.
  \item "raw" Used for debugging.
}}

\item{minConsumption}{Named list of scalars or numeric vectors. Minimum consumption of the alternatives, if consumed. As many elements as alternatives. Names must match those in \code{alternatives}.}

\item{rows}{Boolean vector. Consideration of rows in the likelihood calculation, FALSE to exclude. Length equal to the number of observations (nObs). Default is \code{"all"}, equivalent to \code{rep(TRUE, nObs)}.}

\item{componentName}{Character. Name given to model component.}
}
\value{
The returned object depends on the value of argument \code{functionality} as follows.
        \itemize{
          \item \code{"estimate"}: vector/matrix/array. Returns the probabilities for the chosen alternative for each observation.
          \item \code{"prediction"}: A matrix with one row per observation, and means and s.d. of predicted consumptions.
          \item \code{"validate"}: Boolean. Returns TRUE if all tests are passed.
          \item \code{"zero_LL"}: Not applicable.
          \item \code{"conditionals"}: Same as "prediction".
          \item \code{"output"}: Same as "estimate" but also writes summary of choices into temporary file (later read by \code{apollo_modelOutput}).
          \item \code{"raw"}: Same as "prediction".
        }
}
\description{
Calculates the likelihood of a Multiple Discrete Continuous Extreme Value (MDCEV) model without an outside good.
}
