% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_avgIntraDraws.R
\name{apollo_avgIntraDraws}
\alias{apollo_avgIntraDraws}
\title{Averages intra-individual draws}
\usage{
apollo_avgIntraDraws(P, apollo_inputs, functionality)
}
\arguments{
\item{P}{List of vectors, matrices or 3-dim arrays. Likelihood of the model components.}

\item{apollo_inputs}{List grouping most common inputs. Created by function \link{apollo_validateInputs}.}

\item{functionality}{Character. Description of the desired output from \code{apollo_probabilities}. Can take the values: "estimate", "prediction", "validate", "zero_LL", "conditionals", "output", "raw".}
}
\value{
Likelihood averaged over intra-individual draws (shape depends on argument \code{functionality}).
        \itemize{
          \item \strong{\code{"estimate"}}: Returns the likelihood of the model averaged across intra-individual draws. Drops all components but \code{"model"}.
          \item \strong{\code{"prediction"}}: Returns the likelihood of all alternatives and all model components averaged across intra-individual draws.
          \item \strong{\code{"validate"}}: Same as \code{"estimate"}.
          \item \strong{\code{"zero_LL"}}: Returns \code{P} without changes.
          \item \strong{\code{"conditionals"}}: Same as \code{"estimate"}.
          \item \strong{\code{"output"}}: Returns the likelihood of all model components averaged across intra-individual draws.
          \item \strong{\code{"raw"}}: Returns \code{P} without changes.
        }
}
\description{
Averages observation-specific likelihood across intra-individual draws.
}
