% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_validateInputs.R
\name{apollo_validateInputs}
\alias{apollo_validateInputs}
\title{Prepares input for \code{apollo_estimate}}
\usage{
apollo_validateInputs(apollo_beta = NA, apollo_fixed = NA,
  database = NA, apollo_control = NA, apollo_HB = NA,
  apollo_draws = NA, apollo_randCoeff = NA, apollo_lcPars = NA,
  silent = FALSE)
}
\arguments{
\item{apollo_beta}{Named numeric vector. Names and values for parameters.}

\item{apollo_fixed}{Character vector. Names (as defined in \code{apollo_beta}) of parameters whose value should not change during estimation.}

\item{database}{data.frame. Data used by model.}

\item{apollo_control}{List. Options controlling the running of the code.
\itemize{
  \item modelName: Character. Name of the model. Used when saving the output to files. Avoid characters not allowed in file names, such as \code{\\}, \code{*}, \code{:}, etc.
  \item modelDescr: Character. Description of the model. Used in output files.
  \item indivID: Character. Name of column in the database with each decision maker's ID.
  \item mixing: Boolean. TRUE for models that include random parameters.
  \item nCores: Numeric>0. Number of threads (processors) to use in estimation of the model.
  \item workInLogs: Boolean. TRUE for higher numeric stability at the expense of computational time.
                    Useful for panel models only. Default is FALSE.
  \item seed: Numeric. Seed for random number generation.
  \item HB: Boolean. TRUE if using RSGHB for Bayesian estimation of model.
  \item noValidation: Boolean. TRUE if user does not wish model input to be validated before estimation - FALSE by default.
  \item noDiagnostics: Boolean. TRUE if user does not wish model diagnostics to be printed - FALSE by default.
  \item panelData: Boolean. TRUE if using panelData data (created automatically by \code{apollo_validateControl}).
  \item weights: Character. Name of column in database containing weights for estimation.
}}

\item{apollo_HB}{List. Contains options for bayesian estimation. See \code{?RSGHB::doHB} for details.
Parameters \code{modelname}, \code{gVarNamesFixed}, \code{gVarNamesNormal},
\code{gDIST}, \code{svN} and \code{FC} are automatically set based on the
other arguments of this function.
It should also include a named character vector called \code{hbDist} identifying 
the distribution of each parameter to be estimated. Possible values are as follows.
\itemize{
  \item \code{"DNE"}: Parameter kept at its starting value (not estimated).
  \item \code{"F"}: Fixed (as in non-random) parameter.
  \item \code{"N"}: Normal.
  \item \code{"LN+"}: Positive log-normal.
  \item \code{"LN-"}: Negative log-normal.
  \item \code{"CN+"}: Positive censored normal.
  \item \code{"CN-"}: Negative censored normal.
  \item \code{"JSB"}: Johnson SB.
}}

\item{apollo_draws}{List of arguments describing the inter and intra individual draws. Required only if \code{apollo_control$mixing = TRUE}. Unused elements can be ommited.
\itemize{
  \item \code{interDrawsType}: Character. Type of inter-individual draws ('halton','mlhs','pmc','sobol','sobolOwen',
                               'sobolFaureTezuka', 'sobolOwenFaureTezuka' or the name of an object loaded in memory,
                               see manual in www.ApolloChoiceModelling.com for details).
  \item \code{interNDraws}: Numeric scalar (>=0). Number of inter-individual draws per individual. Should be set to 0 if not using them.
  \item \code{interUnifDraws}: Character vector. Names of uniform-distributed inter-individual draws.
  \item \code{interNormDraws}: Character vector. Names of normaly distributed inter-individual draws.
  \item \code{intraDrawsType}: Character. Type of intra-individual draws ('halton','mlhs','pmc','sobol','sobolOwen','sobolFaureTezuka', 'sobolOwenFaureTezuka' or the name of an object loaded in memory).
  \item \code{intraNDraws}: Numeric scalar (>=0). Number of intra-individual draws per individual. Should be set to 0 if not using them.
  \item \code{intraUnifDraws}: Character vector. Names of uniform-distributed intra-individual draws.
  \item \code{intraNormDraws}: Character vector. Names of normaly distributed intra-individual draws.
}}

\item{apollo_randCoeff}{Function. Used with mixing models. Constructs the random parameters of a mixing model. Receives two arguments:
\itemize{
  \item apollo_beta: Named numeric vector. Names and values of model parameters. 
  \item apollo_inputs: The output of this function (\code{apollo_validateInputs}).
}}

\item{apollo_lcPars}{Function. Used with latent class models. Constructs a list of parameters for each latent class. Receives two arguments:
\itemize{
  \item apollo_beta: Named numeric vector. Names and values of model parameters. 
  \item apollo_inputs: The output of this function (\code{apollo_validateInputs}).
}}

\item{silent}{Boolean. TRUE to keep the function from printing to the console. Default is FALSE.}
}
\value{
List grouping several required input for model estimation.
}
\description{
Searches the user work space for all necessary input to run \code{apollo_estimate}, and packs it in a single list.
}
\details{
All arguments to this function are optional. If the function is called without arguments, then it it will look in
the user workspace (i.e. the global environment) for variables with the same name as its ommited arguments.
}
