% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_interface.R
\name{sedona_read_geojson}
\alias{sedona_read_geojson}
\alias{sedona_read_wkb}
\alias{sedona_read_wkt}
\alias{sedona_read_shapefile}
\title{Read geospatial data into a Spatial RDD}
\usage{
sedona_read_geojson(
  sc,
  location,
  allow_invalid_geometries = TRUE,
  skip_syntactically_invalid_geometries = TRUE,
  storage_level = "MEMORY_ONLY",
  repartition = 1L
)

sedona_read_wkb(
  sc,
  location,
  wkb_col_idx = 0L,
  allow_invalid_geometries = TRUE,
  skip_syntactically_invalid_geometries = TRUE,
  storage_level = "MEMORY_ONLY",
  repartition = 1L
)

sedona_read_wkt(
  sc,
  location,
  wkt_col_idx = 0L,
  allow_invalid_geometries = TRUE,
  skip_syntactically_invalid_geometries = TRUE,
  storage_level = "MEMORY_ONLY",
  repartition = 1L
)

sedona_read_shapefile(sc, location, storage_level = "MEMORY_ONLY")
}
\arguments{
\item{sc}{A \code{spark_connection}.}

\item{location}{Location of the data source.}

\item{allow_invalid_geometries}{Whether to allow topology-invalid
geometries to exist in the resulting RDD.}

\item{skip_syntactically_invalid_geometries}{Whether to allows Sedona to
automatically skip syntax-invalid geometries, rather than throwing
errorings.}

\item{storage_level}{Storage level of the RDD (default: MEMORY_ONLY).}

\item{repartition}{The minimum number of partitions to have in the resulting
RDD (default: 1).}

\item{wkb_col_idx}{Zero-based index of column containing hex-encoded WKB data
(default: 0).}

\item{wkt_col_idx}{Zero-based index of column containing hex-encoded WKB data
(default: 0).}
}
\value{
A SpatialRDD.
}
\description{
Import spatial object from an external data source into a Sedona SpatialRDD.
\itemize{
\item \code{sedona_read_shapefile}: from a shapefile
\item \code{sedona_read_geojson}: from a geojson file
\item \code{sedona_read_wkt}: from a geojson file
\item \code{sedona_read_wkb}: from a geojson file
}
}
\examples{
library(sparklyr)
library(apache.sedona)

sc <- spark_connect(master = "spark://HOST:PORT")

if (!inherits(sc, "test_connection")) {
  input_location <- "/dev/null" # replace it with the path to your input file
  rdd <- sedona_read_geojson(sc, location = input_location)
}

}
\seealso{
Other Sedona RDD data interface functions: 
\code{\link{sedona_read_dsv_to_typed_rdd}()},
\code{\link{sedona_read_shapefile_to_typed_rdd}()},
\code{\link{sedona_save_spatial_rdd}()},
\code{\link{sedona_write_wkb}()}
}
\concept{Sedona RDD data interface functions}
