% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_interface.R
\name{sedona_read_dsv_to_typed_rdd}
\alias{sedona_read_dsv_to_typed_rdd}
\title{Create a typed SpatialRDD from a delimiter-separated values data source.}
\usage{
sedona_read_dsv_to_typed_rdd(
  sc,
  location,
  delimiter = c(",", "\\t", "?", "'", "\\"", "_", "-", "\%", "~", "|", ";"),
  type = c("point", "polygon", "linestring"),
  first_spatial_col_index = 0L,
  last_spatial_col_index = NULL,
  has_non_spatial_attrs = TRUE,
  storage_level = "MEMORY_ONLY",
  repartition = 1L
)
}
\arguments{
\item{sc}{A \code{spark_connection}.}

\item{location}{Location of the data source.}

\item{delimiter}{Delimiter within each record. Must be one of
',', '\\t', '?', '\\'', '"', '_', '-', '\%', '~', '|', ';'}

\item{type}{Type of the SpatialRDD (must be one of "point", "polygon", or
"linestring".}

\item{first_spatial_col_index}{Zero-based index of the left-most column
containing spatial attributes (default: 0).}

\item{last_spatial_col_index}{Zero-based index of the right-most column
containing spatial attributes (default: NULL). Note last_spatial_col_index
does not need to be specified when creating a PointRDD because it will
automatically have the implied value of (first_spatial_col_index + 1).
For all other types of RDDs, if last_spatial_col_index is unspecified, then
it will assume the value of -1 (i.e., the last of all input columns).}

\item{has_non_spatial_attrs}{Whether the input contains non-spatial
attributes.}

\item{storage_level}{Storage level of the RDD (default: MEMORY_ONLY).}

\item{repartition}{The minimum number of partitions to have in the resulting
RDD (default: 1).}
}
\value{
A typed SpatialRDD.
}
\description{
Create a typed SpatialRDD (namely, a PointRDD, a PolygonRDD, or a
LineStringRDD) from a data source containing delimiter-separated values.
The data source can contain spatial attributes (e.g., longitude and latidude)
and other attributes. Currently only inputs with spatial attributes occupying
a contiguous range of columns (i.e.,
[first_spatial_col_index, last_spatial_col_index]) are supported.
}
\examples{
library(sparklyr)
library(apache.sedona)

sc <- spark_connect(master = "spark://HOST:PORT")

if (!inherits(sc, "test_connection")) {
  input_location <- "/dev/null" # replace it with the path to your csv file
  rdd <- sedona_read_dsv_to_typed_rdd(
    sc,
    location = input_location,
    delimiter = ",",
    type = "point",
    first_spatial_col_index = 1L
  )
}

}
\seealso{
Other Sedona data inferface functions: 
\code{\link{sedona_read_geojson_to_typed_rdd}()},
\code{\link{sedona_read_geojson}()},
\code{\link{sedona_read_shapefile_to_typed_rdd}()},
\code{\link{sedona_read_shapefile}()},
\code{\link{sedona_read_wkb}()},
\code{\link{sedona_read_wkt}()},
\code{\link{sedona_save_spatial_rdd}()},
\code{\link{sedona_write_geojson}()},
\code{\link{sedona_write_wkb}()},
\code{\link{sedona_write_wkt}()}
}
\concept{Sedona data inferface functions}
