% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/etaSquaredCI.R
\name{get.ci.partial.eta.squared}
\alias{get.ci.partial.eta.squared}
\title{Calculates confidence interval for partial eta-squared in a fixed-effects ANOVA}
\usage{
get.ci.partial.eta.squared(F.value, df1, df2, conf.level = 0.9)
}
\arguments{
\item{F.value}{The F-value for the fixed-effect}

\item{df1}{Degrees of freedom for the fixed-effect}

\item{df2}{Degrees of freedom error}

\item{conf.level}{Confidence level (0 to 1). For partial eta-squared a confidence level of .90 is traditionally used rather than .95.}
}
\value{
List with confidence interval values (LL and UL)
}
\description{
Calculates confidence interval for partial eta-squared in a fixed-effects ANOVA
}
\examples{
# Smithson (2001) p. 619
get.ci.partial.eta.squared(F.value=6.00, df1=1, df2=42, conf.level=.90)
get.ci.partial.eta.squared(F.value=2.65, df1=6, df2=42, conf.level=.90)
get.ci.partial.eta.squared(F.value=2.60, df1=6, df2=42, conf.level=.90)

# Fidler & Thompson (2001) Fixed Effects 2x4 p. 594 (Table 6) / p. 596 (Table 8)
get.ci.partial.eta.squared(F.value=1.50, df1=1, df2=16, conf.level=.90)
get.ci.partial.eta.squared(F.value=4.00, df1=3, df2=16, conf.level=.90)
get.ci.partial.eta.squared(F.value=1.50, df1=3, df2=16, conf.level=.90)
}
