% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Class.R
\name{Class}
\alias{Class}
\title{Define a Reference Class}
\usage{
Class(expr)
}
\arguments{
\item{expr}{an expression}
}
\description{
This is a wrapper around \code{\link{setRefClass}}. All arguments are defined in an expression (instead of lists) which improves readability of the code. Besides that, no additional features are added.
}
\examples{
\dontrun{
  vignette("Introduction", "aoos")
}

# Minimal example:
Test <- Class({
  Class <- "Test" # this is passed as argument to setRefClass
  x <- "character" # all objects which are not functions are fields
  do <- function() cat("Yes, Yes, I'm working...") # a method
})

test <- Test()
test$x <- "a"
test$do()

# Inheritance and privacy:
pTest <- Class({
  Class <- "pTest"
  # Privacy is solved by inheriting from a class 'Private' which redefines
  # the methods for access.
  contains <- c("Test", "Private") # passed as argument to setRefClass

  .y <- "numeric" # this is going to be 'private'

  doSomething <- function() {
    .self$.y <- 42
    cat(x, .y, "\\n")
    invisible(.self)
  }
})

instance <- pTest()
instance$x <- "Value of .y:"
instance$doSomething()

# A notion of privacy:
stopifnot(inherits(try(instance$.y), "try-error"))
stopifnot(inherits(try(instance$.y <- 2), "try-error"))
}
\seealso{
\link{Private-class}
}

