% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_plugins.R
\name{addDirectedSegments}
\alias{addDirectedSegments}
\alias{updateDirectedSegments}
\title{Add or update directed segments}
\usage{
addDirectedSegments(map, x0, y0, x1, y1, color = "blue", weight = 3,
  opacity = 1, dir = 1, popup = NULL, layerId = NULL)

updateDirectedSegments(map, layerId, color = NULL, weight = NULL,
  opacity = NULL, dir = NULL, popup = NULL)
}
\arguments{
\item{map}{A map object created with \code{\link[leaflet]{leaflet}()}}

\item{x0}{longitude of the origin of the segments}

\item{y0}{lattitude of the origin of the segments}

\item{x1}{longitude of the destination of the segments}

\item{y1}{lattitude of the destination of the segments}

\item{color}{color of the segments}

\item{weight}{line width of the segments}

\item{opacity}{opacity of the segments}

\item{dir}{direction of the segments. Possible values are -1, 0 and 1. If it equals
to 0, then no arrow is drawn. If it equals 1 an arrow is drawn and 
points to the destination of the segment. If it equals to -1, then the arrow 
is reversed and points to the origin of the segment.}

\item{popup}{a character vector of the HTML content for the popups. They are displayed 
when user clicks on a segment.}

\item{layerId}{Layer id.}
}
\value{
The modified map object.
}
\description{
These functions add or update directed segments on a leaflet map: they are 
simply lines with an arrow in their middle that represent their direction.
}
\examples{
require(leaflet)

leaflet() \%>\% 
  addDirectedSegments(
    x0 = c(0, 0, 0),
    y0 = c(0, 1, 2),
    x1 = c(3, 3, 3),
    y1 = c(0, 1, 2),
    weight = c(1, 2, 3),
    dir = c(0, 1, -1)
  )

}
