% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/API-methods.R
\name{API-methods}
\alias{API-methods}
\alias{api_get}
\alias{api_post}
\alias{api_put}
\alias{api_delete}
\title{API methods}
\usage{
api_get(opts, endpoint, ..., default_endpoint = "v1/studies")

api_post(opts, endpoint, ..., default_endpoint = "v1/studies")

api_put(opts, endpoint, ..., default_endpoint = "v1/studies")

api_delete(opts, endpoint, ..., default_endpoint = "v1/studies")
}
\arguments{
\item{opts}{Antares simulation options or a \code{list} with an \verb{host = } slot.}

\item{endpoint}{API endpoint to interrogate, it will be added after \code{default_endpoint}.
Can be a full URL (by wrapping ìn \code{\link[=I]{I()}}), in that case \code{default_endpoint} is ignored.}

\item{...}{Additional arguments passed to API method.}

\item{default_endpoint}{Default endpoint to use.}
}
\value{
Response from the API.
}
\description{
API methods
}
\examples{
\dontrun{

# List studies with local API
api_get(
  opts = list(host = "http://0.0.0.0:8080"),
  endpoint = NULL
)

}
}
