% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readLayout.R
\name{readLayout}
\alias{readLayout}
\title{Read areas layout}
\usage{
readLayout(opts = simOptions(), xyCompare = c("union", "intersect"))
}
\arguments{
\item{opts}{list of simulation parameters returned by the function
\code{\link{setSimulationPath}}}

\item{xyCompare}{Use when passing multiple opts, can be "union" or "intersect".}
}
\value{
A list with three elements:
\item{areas: }{A data.frame containing the name, the color and the coordinate
   of each area}
\item{district: }{A data.frame containing the name, the color and the coordinate
   of each district}
\item{links: }{A data.frame containing the name, the coordinates of the origin
   and the destination of each link}
   
By default, \code{readLayout} reads the layout for the current default
antares study. It is possible to specify another study with the parameter
\code{opts}. And we can pass multiple studies using a \code{list} of opts.
}
\description{
This function reads in the input files of an antares study the current areas
layout, ie. the position of the areas It may be useful for plotting the
network. 

Be aware that the layout is read in the input files so they may have
changed since a simulation has been run.
}
\examples{
\dontrun{
readLayout()

# By default, the function reads layout for the default study,
# but it is possible to specify another study with parameter "opts"
sim1 <- setSimulationPath()

#[... code that modifies the default antares study]

readLayout(sim1)

}

}
