% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addConvergencePriceSystem.R
\name{addConvergencePriceSystem}
\alias{addConvergencePriceSystem}
\title{addConvergencePriceSystem}
\usage{
addConvergencePriceSystem(antaresData = NULL)
}
\arguments{
\item{antaresData}{Object of class \code{antaresData} created with function
\code{\link[antaresRead]{readAntares}}. antaresData must contains areas and
links details data with linkCapacity.}
}
\description{
This function computes priceConvergenceSystem, priceConvergenceSystem represent
the biggest system without congestion.
}
\examples{
\dontrun{

  myData <- readAntares(areas = "all",
  links = "all",
  showProgress = FALSE,
  linkCapacity = TRUE,
  mcYears = "all")

  myDataRV <- removeVirtualAreas(x = myData,
  storageFlexibility = getAreas(c("psp", "hub")),
  production = getAreas("off"))

  addConvergencePriceSystem(myData)
}
}
