% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate}
\alias{simulate}
\title{A function for generating simulated multivariate data}
\usage{
simulate(
  n = 100,
  p = 10,
  mu = 1,
  locations = 40,
  durations = 20,
  proportions = 0.1
)
}
\arguments{
\item{n}{The number of observations. The default is \code{n=100}.}

\item{p}{The number of variates. The default is \code{p=10}.}

\item{mu}{The change in mean. Default is \code{mu=1}.}

\item{locations}{A vector of locations (or scalar for a single location) where the change in mean occurs. The default is \code{locations=20}.}

\item{durations}{A scalar or vector (the same length as \code{locations}) of values indicating the duration for the change in mean. If the durations are all
of the same length then a scalar value can be used. The default is \code{durations=20}.}

\item{proportions}{A scalar or vector (the same length as \code{locations}) of values in the range (0,1] indicating the proportion of variates at each location that are affected by
the change in mean. If the proportions are all same than a scalar value can be used. The default is \code{proportions=0.1}.}
}
\value{
A matrix with n rows and p columns
}
\description{
Generates multivariate simulated data having n observations and p variates. The data have a standard Gaussian distribution except at
a specified number of locations where there is a change in mean in a proportion of the variates. The function is useful for generating data to demonstrate and assess
multivariate anomaly detection methods such as \code{capa.mv} and \code{pass}.
}
\examples{
library(anomaly)
sim.data<-simulate(500,200,2,c(100,200,300),6,c(0.04,0.06,0.08))

}
