% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/MembershipFunction-derivateMF.R
\docType{methods}
\name{derivateMF}
\alias{derivateMF}
\alias{derivateMF,BellMF-method}
\alias{derivateMF,GaussianMF-method}
\alias{derivateMF,MembershipFunction-method}
\alias{derivateMF,NormalizedGaussianMF-method}
\alias{derivateMF-methods}
\title{\code{derivateMF} derivate membership function}
\usage{
derivateMF(object, x, i)

\S4method{derivateMF}{MembershipFunction}(object, x, i)

\S4method{derivateMF}{BellMF}(object, x, i)

\S4method{derivateMF}{GaussianMF}(object, x, i)

\S4method{derivateMF}{NormalizedGaussianMF}(object, x, i)
}
\arguments{
\item{object}{MembershipFunction class heirs}

\item{x}{numeric of the MembershipFunction to be evaluated}

\item{i}{index of the ith parameter to partially derivate}
}
\value{
numeric with the value obtained from the ith derivative at x
}
\description{
Derivate de membership of x with respect to i of MembershipFunction object
heirs.








}
\examples{
#BellMF example I
#A bell membership function with default prototype (a=1, b=1,c=0)
#The membership of x in the bell, should be 1
#The derivate of the first parameter at x, should be 0
#The derivate of the first parameter at x, should be also 0
bell <- new(Class="BellMF")
bell
evaluateMF(object=bell, x=0)
derivateMF(object=bell, x=0, i=1)
derivateMF(object=bell, x=0, i="a")
#
#BellMF example II
#A bell membership function with parameters (a=4,b=1,c=-10)
#The membership of x in the bell, should be 0.137931
#The derivate of the first parameter at x, should be 0.05945303
#The derivate on "a" at x=0, should be 0.05945303
bell2 <- new(Class="BellMF",parameters=c(a=4,b=1,c=-10))
bell2
evaluateMF(object=bell2, x=0)
derivateMF(object=bell2, x=0, i=1)
derivateMF(object=bell2, x=0, i="a")
#GaussianMF example I
#A Gaussian membership function with default prototype (mu=0, sigma=1)
#The membership of x in the gaussian, should be 1/sqrt(2*pi) = 0.3989423
#The derivate of the first parameter at x, should be 0
#The derivate on "mu" parameter at x, should be 0
gaussian <- new(Class="GaussianMF")
gaussian
evaluateMF(object=gaussian, x=0)
derivateMF(object=gaussian, x=0, i=1)
derivateMF(object=gaussian, x=0, i="mu")
#
#GaussianMF example II
#A Gaussian membership function with parameters (mu=0, sigma=1)
#The membership of x in the Gaussian, should be 1/sqrt(2*pi) = 0.3989423
#The derivate of the first parameter at x, should be 0
#The derivate on "mu" parameter at x, should be 0
gaussian2 <- new(Class="GaussianMF",parameters=c(mu=0,sigma=1))
gaussian2
evaluateMF(object=gaussian2, x=0)
derivateMF(object=gaussian2, x=0, i=1)
derivateMF(object=gaussian2, x=0, i="mu")
#NormalizedGaussianMF example I
#A normalized Gaussian membership function with default parameters (mu=0, sigma=1)
#The derivate of the first parameter at x, should be 1
#The derivate of the first parameter at x, should be 0
#The derivate on "mu" parameter at x, should be 0
normalizedGaussian <- new(Class="NormalizedGaussianMF")
normalizedGaussian
evaluateMF(object=normalizedGaussian, x=0)
derivateMF(object=normalizedGaussian, x=0, i=1)
derivateMF(object=normalizedGaussian, x=0, i="mu")
#
#NormalizedGaussianMF example II
#A normalized Gaussian membership function with parameters (mu=0, sigma=1)
#The derivate of the first parameter at x, should be 1
#The derivate of the first parameter at x, should be 0
#The derivate on "mu" parameter at x, should be 0
normalizedGaussian2 <- new(Class="NormalizedGaussianMF",
 parameters=c(mu=0,sigma=1))
normalizedGaussian2
evaluateMF(object=normalizedGaussian2, x=0)
derivateMF(object=normalizedGaussian2, x=0, i=1)
derivateMF(object=normalizedGaussian2, x=0, i="mu")
}
\author{
Cristobal Fresno \email{cfresno@bdmg.com.ar}, Andrea S. Llera
 \email{ALlera@leloir.org.ar} and Elmer A. Fernandez
 \email{efernandez@bdmg.com.ar}
}
\seealso{
\code{\link{MembershipFunction-class}} and \code{\link{evaluateMF}}

Other Membership Functions: \code{\link{BellMF}},
  \code{\link{BellMF-class}}; \code{\link{GaussianMF}},
  \code{\link{GaussianMF-class}};
  \code{\link{MembershipFunction}},
  \code{\link{MembershipFunction-class}};
  \code{\link{NormalizedGaussianMF}},
  \code{\link{NormalizedGaussianMF-class}};
  \code{\link{[,MembershipFunction-method}},
  \code{\link{[<-,MembershipFunction-method}},
  \code{\link{extract-methods}},
  \code{\link{extract-methods}}; \code{\link{evaluateMF}},
  \code{\link{evaluateMF}}, \code{\link{evaluateMF}},
  \code{\link{evaluateMF}}, \code{\link{evaluateMF}},
  \code{\link{evaluateMF,BellMF-method}},
  \code{\link{evaluateMF,GaussianMF-method}},
  \code{\link{evaluateMF,MembershipFunction-method}},
  \code{\link{evaluateMF,NormalizedGaussianMF-method}},
  \code{\link{evaluateMF-methods}};
  \code{\link{print,MembershipFunction-method}};
  \code{\link{show,MembershipFunction-method}}
}

