% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlyingness.R
\name{outlyingness}
\alias{outlyingness}
\title{outlyingness}
\usage{
outlyingness(x, type = 1, step = 100, xlim = NULL, normalize = 1)
}
\arguments{
\item{x}{data frame}

\item{type}{type of curve, see \code{\link[=andrews]{andrews()}}}

\item{step}{step    smoothness of curves}

\item{xlim}{the x limits (x1, x2)}

\item{normalize}{type of normalization, see \code{\link[=normalize]{normalize()}}}
}
\value{
the Stahel-Donoho outlyingness
}
\description{
Computes the Stahel-Donoho outlyingness. If \code{type} is any of the available types by \code{\link[=andrews]{andrews()}} then
the projection vectors are generated along the andrews curves. Otherwise \code{step} random directions
will be used. Note that the projection vectors are always normalized to length one.
}
\examples{
# use projection vectors from the Andrews curve
sdo <- outlyingness(iris)
col <- gray(1-sdo/max(sdo))
andrews(iris, clr=col, ymax=NA)
# use 1000 random projection vectors
sdo <- outlyingness(iris, type=0, step=1000)
col <- gray(1-sdo/max(sdo))
andrews(iris, clr=col, ymax=NA)
# use 1000 random projection vectors with adjusted outlyingness
library("robustbase")
x   <- numarray(iris)
x   <- scale(x, center=apply(x, 2, min), scale=apply(x, 2, max)-apply(x, 2, min))
sdo <- adjOutlyingness(x, ndir=1000, only.outlyingness=TRUE)
col <- gray(1-sdo/max(sdo))
andrews(as.data.frame(x), clr=col, ymax=NA)
}
\references{
\itemize{
\item Stahel, W. (1981), Robuste Schätzungen: infinitesimale Optimalität und Schätzungen von Kovarianzmatrizen, PhD thesis, ETH Z¨urich.
\item Donoho, D. (1982), Breakdown properties of multivariate location estimators, Ph.D. Qualifying paper, Dept. Statistics, Harvard University, Boston.
}
}
