% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keys.R
\name{key-crud}
\alias{key-crud}
\alias{key_create}
\alias{key_rename}
\alias{key_delete}
\title{Create, update, and delete ssh keys.}
\usage{
key_create(name, public_key, ...)

key_rename(key, name, ...)

key_delete(key, ...)
}
\arguments{
\item{name}{(character) The name to give the new SSH key in your account.}

\item{public_key}{(character) A string containing the entire public key.}

\item{...}{Other options passed on to low-level API methods.}

\item{key}{(key) Key to modify.}
}
\description{
Create, update, and delete ssh keys.
}
\examples{
\dontrun{
k <- key_create("key", readLines("~/.ssh/id_rsa.pub"))
k <- key_rename(k, "new_name")
key_delete(k)
}
}
