% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{trmvrnorm_rej_cpp}
\alias{trmvrnorm_rej_cpp}
\title{Sample from truncated multivariate normal distribution with C++}
\usage{
trmvrnorm_rej_cpp(n, mu, sigma, lower, upper, verb)
}
\arguments{
\item{n}{number of simulations.}

\item{mu}{mean vector.}

\item{sigma}{covariance matrix.}

\item{lower}{vector of lower bounds.}

\item{upper}{vector of upper bounds.}

\item{verb}{level of verbosity: if lower than 3 nothing, 3 minimal, 4 extended.}
}
\value{
A matrix of size \eqn{d x n} containing the samples.
}
\description{
Simulates realizations from a truncated multivariate normal with mean mu, covariance matrix sigma in the bounds lower upper.
}
\examples{
# Simulate 1000 realizations from a truncated multivariate normal vector
mu <- rep(0,10)
Sigma <- diag(rep(1,10))
upper <- rep(3,10)
lower <- rep(-0.5,10)
realizations<-trmvrnorm_rej_cpp(n=1000,mu = mu,sigma=Sigma, lower =lower, upper= upper,verb=3)
empMean<-rowMeans(realizations)
empCov<-cov(t(realizations))
# check if the sample mean is close to the actual mean
maxErrorOnMean<-max(abs(mu-empMean))
# check if we can estimate correctly the covariance matrix
maxErrorOnVar<-max(abs(rep(1,200)-diag(empCov)))
maxErrorOnCov<-max(abs(empCov[lower.tri(empCov)]))
\dontrun{
plot(density(realizations[1,]))
hist(realizations[1,],breaks="FD")
}
}
\references{
Horrace, W. C. (2005). Some results on the multivariate truncated normal distribution. Journal of Multivariate Analysis, 94(1):209--221.

Robert, C. P. (1995). Simulation of truncated normal variables. Statistics and Computing, 5(2):121--125.
}
