% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hr_akde.R, R/hr_area.R, R/hr_documentation.R,
%   R/hr_isopleths.R, R/hr_kde.R, R/hr_locoh.R, R/hr_mcp.R
\name{hr_akde}
\alias{hr_akde}
\alias{hr_akde.track_xyt}
\alias{hr_area}
\alias{hr}
\alias{hr_isopleths}
\alias{hr_kde}
\alias{hr_kde.track_xy}
\alias{hr_kde_ref}
\alias{hr_kde_ref.track_xy}
\alias{hr_kde_pi}
\alias{hr_kde_pi.track_xy}
\alias{hr_kde_lscv}
\alias{hr_locoh}
\alias{hr_locoh.track_xy}
\alias{hr_mcp}
\alias{hr_mcp.track_xy}
\title{Home ranges}
\usage{
hr_akde(x, ...)

\method{hr_akde}{track_xyt}(x, model = fit_ctmm(x, "iid"),
  trast = make_trast(x), ...)

hr_area(x, ...)

hr_isopleths(x, ...)

hr_kde(x, ...)

\method{hr_kde}{track_xy}(x, h = hr_kde_ref(x), trast = make_trast(x),
  ...)

hr_kde_ref(x, ...)

\method{hr_kde_ref}{track_xy}(x, rescale = "none", ...)

hr_kde_pi(x, ...)

\method{hr_kde_pi}{track_xy}(x, rescale = "none", correct = TRUE, ...)

hr_kde_lscv(x, range = do.call(seq, as.list(c(hr_kde_ref(x) * c(0.1, 2),
  length.out = 100))), which_min = "global", rescale = "none",
  trast = raster(as_sp(x), nrow = 100, ncol = 100))

hr_locoh(x, ...)

\method{hr_locoh}{track_xy}(x, n = 10, type = "k", levels = 0.95,
  rand_buffer = 1e-05, ...)

hr_mcp(x, ...)

\method{hr_mcp}{track_xy}(x, levels = 0.95, ...)
}
\arguments{
\item{x}{\code{[track_xy, track_xyt]} \cr A track created with \code{make_track}.}

\item{...}{Further arguments, none implemented.}

\item{model}{A continous time movement model. This can be fitted either with \code{ctmm::ctmm.fit} or \code{fit_ctmm}.}

\item{trast}{\code{[RasterLayer]} \cr A template raster for kernel density home-ranges.}

\item{h}{\code{[numeric(2)]} \cr The bandwidth for kernel density estimation.}

\item{rescale}{\code{[character(1)]} \cr Rescaling method for reference bandwidth calucation. Must be one of "unitvar", "xvar", or "none".}

\item{correct}{Logical scalar that indicates whether or not the estimate should be correct for the two dimensional case.}

\item{range}{numeric vector with different candidate h values.}

\item{which_min}{A character indicating if the \code{global} or \code{local} minimum should be searched for.}

\item{n}{\code{[integer(1)]} \cr The number of neighbors used when calculating
local convex hulls.}

\item{type}{\code{k}, \code{r} or \code{a}. Type of LoCoH.}

\item{levels}{\code{[numeric]} \cr The isopleth levels used for calculating home
ranges. Should be \code{0 < level < 1}.}

\item{rand_buffer}{\code{[numeric(1)]} \cr Random buffer to avoid polygons with
area 0 (if coordinates are numerically identical).}
}
\value{
The bandwidth, the standardization method and correction.

\code{vector} of length two
}
\description{
Functions to calculate animal home ranges from a \code{track_xy*}, and to work
with home ranges. \code{hr_mcp}, \code{hr_kde}, and \code{hr_locoh} calculate the minimum convex
polygon, kernel density, and local convex hull home range respectively. \code{hr_area} extracts the
area of an home range, \code{hr_isopleths} returns the isopleth as a
\code{SpatialPolygonsDataFrame}.
}
\details{
The implementation of the reference bandwidth calculation is based on Worton (1989). If variances differ greatly, it is advaisable to rescale the data using \code{rescale = "unitvar"} the data is suspected to multimodal other bandwidth estimation methods may be more suitable.

\code{hr_kde_lscv} calcualtes least square cross validation bandwidth. This implementation is based on Seaman and Powell (1996).  If \code{whichMin} is \code{"global"} the global minimum is returned, else the local minimum with the largest candidate bandwidth is returned.
}
\examples{
# akde
\dontrun{
data(deer)
ud1 <- hr_akde(deer) # uses an iid ctmm
ud2 <- hr_akde(deer, model = fit_ctmm(deer, "ou")) # uses an OU ctmm
}
data(deer)
mini_deer <- deer[1:100, ]

# MCP ---------------------------------------------------------------------
mcp1 <- hr_mcp(mini_deer)
hr_area(mcp1)

# calculated MCP at different levels
mcp1 <- hr_mcp(mini_deer, levels = seq(0.3, 1, 0.1))
hr_area(mcp1)

# CRS are inherited
get_crs(mini_deer)
mcps <- hr_mcp(mini_deer, levels = c(0.5, 0.95, 1))
has_crs(mcps)

# Local Convex Hull (LoCoH) -----------------------------------------------
locoh1 <- hr_locoh(mini_deer)
hr_area(locoh1)

# calculated Locoh at different levels
locoh <- hr_locoh(mini_deer, levels = seq(0.3, 1, 0.1))
hr_area(locoh)


# Kernel density estimaiton (KDE) -----------------------------------------
kde1 <- hr_kde(mini_deer)
hr_area(kde1)
get_crs(kde1)
}
\references{
C. H. Fleming, W. F. Fagan, T. Mueller, K. A. Olson, P. Leimgruber, J. M. Calabrese, “Rigorous home-range estimation with movement data: A new autocorrelated kernel-density estimator”, Ecology, 96:5, 1182-1188 (2015).

Worton, B. J. (1989). Kernel methods for estimating the utilization distribution in home-range studies. \emph{Ecology, 70(1)}, 164-168.

Gitzen, R. A., Millspaugh, J. J., & Kernohan, B. J. (2006). Bandwidth selection for fixed-kernel analysis of animal utilization distributions. \emph{Journal of Wildlife Management}, 70(5), 1334-1344.

Seaman, D. E., & Powell, R. A. (1996). An evaluation of the accuracy of kernel density estimators for home range analysis. \emph{Ecology, 77(7)}, 2075-2085.
}
\seealso{
\code{KernSmooth::dpik}
}
