% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_amps.R
\name{predict_amps}
\alias{predict_amps}
\title{Predict the antimicrobial peptide probability of a protein}
\usage{
predict_amps(faa_df, min_len = 5)
}
\arguments{
\item{faa_df}{A dataframe obtained from \code{read_faa}) containing two columns: the sequence name (seq_name) and amino acid sequence (seq_aa)}

\item{min_len}{The minimum protein length for which predictions will be generated}
}
\value{
The original input data.frame with a new column added called \code{prob_AMP} with the probability of that sequence to be an antimicrobial peptide. Any sequences that are too short or which contain invalid amin acids will have NA in this column
}
\description{
This function predicts the probability of a protein to be an antimicrobial peptide
}
\examples{

my_bat_faa_df <- read_faa(system.file("extdata/bat_protein.fasta", package = "ampir"))

predict_amps(my_bat_faa_df)
#       seq_name    prob_AMP
# [1] G1P6H5_MYOLU  0.9723796
}
