% Generated by roxygen2 (4.0.2): do not edit by hand
\name{summary.ame}
\alias{summary.ame}
\title{Summary of an AME object}
\usage{
\method{summary}{ame}(object, ...)
}
\arguments{
\item{object}{the result of fitting an AME model}

\item{...}{additional parameters (not used)}
}
\value{
a summary of parameter estimates and confidence intervals for an AME
fit
}
\description{
Summary method for an AME object
}
\examples{
## The function is currently defined as
function(object, ...)
{
  fit<-object
require(amen)
    tmp <- cbind(apply(fit$BETA, 2, mean), apply(fit$BETA, 2,
        sd), apply(fit$BETA, 2, mean)/apply(fit$BETA, 2, sd),
        2 * (1 - pnorm(abs(apply(fit$BETA, 2, mean)/apply(fit$BETA,
            2, sd)))))
    colnames(tmp) <- c("pmean", "psd", "z-stat", "p-val")
    cat("\\nbeta:\\n")
    print(round(tmp, 3))
    tmp <- apply(fit$SABR, 2, mean)
    Sab <- matrix(tmp[c(1, 2, 2, 3)], 2, 2)
    dimnames(Sab) <- list(c("a", "b"), c("a", "b"))
    cat("\\nSigma_ab pmean:\\n")
    print(round(Sab, 3))
    cat("\\nrho pmean:\\n", round(tmp[4], 3), "\\n")
  }
}
\author{
Peter Hoff
}

