% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.ad.R
\name{predict.ad}
\alias{predict.ad}
\title{Predict method for ad Objects}
\usage{
\method{predict}{ad}(object, newdata, type = "class", na.action = na.pass,
  ...)
}
\arguments{
\item{object}{An object of class \code{ad}, created by the function \code{ad}.}

\item{newdata}{A data frame or matrix containing new data.}

\item{type}{One of 'class' (for class prediction) or 'prob' (for probabilities).}

\item{na.action}{A function specifying the action to be taken if NAs are
found; default is to predict NA (na.pass).}

\item{...}{Currently not used.}
}
\value{
A vector of predicted values.
}
\description{
Predict method for ad Objects
}
\details{
Specifying 'class' for \code{type} returns the class of each
observation as anomalous or non-anomalous. Specifying 'prob' returns the
probability of each observation.
}
\examples{

x1 <- c(1,.2,3,1,1,.7,-2,-1)
x2 <- c(0,.5,0,.4,0,1,-.3,-.1)
x <- do.call(cbind,list(x1,x2))
y <- c(0,0,0,0,0,0,1,1)
dframe <- data.frame(x,y)
df_fit <- ad(y ~ x1 + x2, dframe)
predict(df_fit, newdata = dframe)

}
