% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worley.R
\name{noise_worley}
\alias{noise_worley}
\title{Worley (cell) noise generator}
\usage{
noise_worley(dim, frequency = 0.01, distance = "euclidean",
  value = "cell", distance_ind = c(1, 2), jitter = 0.45,
  pertubation = "none", pertubation_amplitude = 1)
}
\arguments{
\item{dim}{The dimensions (height, width, (and depth)) of the noise to be
generated. The length determines the dimensionality of the noise.}

\item{frequency}{Determines the granularity of the features in the noise.}

\item{distance}{The distance measure to use, either \code{'euclidean'} (default),
\code{'manhattan'}, or \code{'natural'} (a mix of the two)}

\item{value}{The noise value to return. Either
\itemize{
\item \code{'value'} (default) A random value associated with the closest point
\item \code{'distance'} The distance to the closest point
\item \code{'distance2'} The distance to the nth closest point (n given by
\code{distance_ind[1]})
\item \code{'distance2add'} Addition of the distance to the nth and mth closest point given in \code{distance_ind}
\item \code{'distance2sub'} Substraction of the distance to the nth and mth closest point given in \code{distance_ind}
\item \code{'distance2mul'} Multiplication of the distance to the nth and mth closest point given in \code{distance_ind}
\item \code{'distance2div'} Division of the distance to the nth and mth closest point given in \code{distance_ind}
}}

\item{distance_ind}{Reference to the nth and mth closest points that should
be used when calculating \code{value}.}

\item{jitter}{The maximum distance a point can move from its start position
during sampling of cell points.}

\item{pertubation}{The pertubation to use. Either \code{'none'} (default),
\code{'normal'}, or \code{'fractal'}. Defines the displacement (warping) of the noise,
with \code{'normal'} giving a smooth warping and \code{'fractal'} giving a more eratic
warping.}

\item{pertubation_amplitude}{The maximal pertubation distance from the
origin. Ignored if \code{pertubation = 'none'}. Defaults to \code{1}.}
}
\value{
If \code{length(dim) == 2} a matrix, if \code{length(dim) == 3} a 3-dimensional
array.
}
\description{
Worley noise, sometimes called cell (or cellular) noise, is quite distinct
due to it's kinship to voronoi tesselation. It is created by sampling random
points in space and then for any point in space measure the distance to the
closest point. The noise can be modified further by changing either the
distance measure or by combining multiple distances. The noise algorithm was
developed by Steven Worley in 1996 and has been used to simulated water and
stone textures among other things.
}
\examples{
# Basic use
noise <- noise_worley(c(100, 100))

image(noise, col = grey.colors(256, 0, 1))

}
\references{
Worley, Steven (1996). \emph{A cellular texture basis function}. Proceedings of the 23rd annual conference on computer graphics and interactive techniques. pp. 291–294. ISBN 0-89791-746-4
}
