% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/horizontal.R
\name{update_horizontally}
\alias{update_horizontally}
\title{Horizontal distribution of the flow in grid.}
\usage{
update_horizontally(h, beta)
}
\arguments{
\item{h}{Initial head}

\item{beta}{a parameter based on the diffusivity, time step and grid size.}
}
\value{
Returns the updated head.
}
\description{
Simulates the horizontal distribution of the flow in grids based on the diffusivity.
}
\examples{



# create synthetic head:
h <- cbind(c(1,2,3),c(4,5,6),c(7,8,9))
h
beta <- 0.5
h1 <- update_horizontally(h, beta)
h1

# increase the value of beta:
beta <- 1.0
h1 <- update_horizontally(h, beta)

# decrease the value of beta:
beta <- 0
h1 <- update_horizontally(h, beta)
h1

}
