% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intFun.R
\name{intFun.min.max.int.raw}
\alias{intFun.min.max.int.raw}
\title{Range and interval for color bar legend}
\usage{
intFun.min.max.int.raw(x)
}
\arguments{
\item{x}{An R object}
}
\value{
Minimum, maximum, and interval value for color bar legend
}
\description{
This function returns the minimum, maximum, and interval value
that can be used to define a color bar legend. Contary to \link{intFun.min.max.int},
this function does not use any rounding to find pretty values for min, max, int,
which is an advantage for plotting data with extremely small numerical values.
}
\examples{

library(raster)
library(spatial.tools)
library(classInt)
# create a raster object
data <- runif(100,0,10^(-5))
data <- matrix(data, ncol=10)
data <- raster::raster(data)
# Get min, max, and interval for color bar legend
mmi <- intFun.min.max.int.raw(data)

}
\keyword{internal}
