% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amanida_read.R
\name{amanida_read}
\alias{amanida_read}
\title{Import data}
\usage{
amanida_read(file, mode, coln, separator = NULL)
}
\arguments{
\item{file}{path to file}

\item{mode}{indicate if data will be quantitative or qualitative. Options are:
\itemize{
\item "quan" for quantitative meta-analysis using p-value and fold-change
\item "qual" for qualitative meta-analysis using trend label
}}

\item{coln}{columns names to use}

\item{separator}{the separator used on file}
}
\value{
tibble table with data imported
}
\description{
\code{amanida_read} imports the data and formats for \code{compute_amanida}
or \code{amanida_vote} functions
}
\details{
Note that \code{amanida_read} skips rows with missing values or NA.

Formats compatible are csv, xlsx, xls or txt.
}
\examples{
coln = c("Compound Name", "P-value", "Fold-change", "N total", "References")
input_file <- system.file("extdata", "dataset2.csv", package = "amanida")
datafile <- amanida_read(input_file, mode = "quan", coln, separator=";")

}
