% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{process_gridmet}
\alias{process_gridmet}
\title{Process gridMET data}
\usage{
process_gridmet(
  date = c("2023-09-01", "2023-09-10"),
  variable = NULL,
  path = NULL,
  extent = NULL,
  ...
)
}
\arguments{
\item{date}{character(1 or 2). Date (1) or start and end dates (2).
Format YYYY-MM-DD (ex. September 1, 2023 = "2023-09-01").}

\item{variable}{character(1). Variable name or acronym code. See \href{https://www.climatologylab.org/wget-gridmet.html}{gridMET Generate Wget File}
for variable names and acronym codes. (Note: variable "Burning Index" has code "bi" and variable
"Energy Release Component" has code "erc").}

\item{path}{character(1). Directory with downloaded netCDF (.nc) files.}

\item{extent}{numeric(4) or SpatExtent giving the extent of the raster
if \code{NULL} (default), the entire raster is loaded}

\item{...}{Placeholders.}
}
\value{
a \code{SpatRaster} object
}
\description{
The \code{process_gridmet()} function imports and cleans raw gridded surface meteorological
data, returning a single \code{SpatRaster} object.
}
\note{
Layer names of the returned \code{SpatRaster} object contain the variable acronym,
and date.
}
\examples{
## NOTE: Example is wrapped in `\dontrun{}` as function requires a large
##       amount of data which is not included in the package.
\dontrun{
gridmet <- process_gridmet(
  date = c("2023-01-01", "2023-01-10"),
  variable = "Precipitation",
  path = "./data/pr"
)
}
}
\author{
Mitchell Manware
}
