% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JABt.R
\name{JABt}
\alias{JABt}
\title{Transforms a t-statistic into Jeffreys' approximate Bayes factor}
\usage{
JABt(n, t, method = "JAB", upper = 1)
}
\arguments{
\item{n}{Sample size.}

\item{t}{The t-statistic.}

\item{method}{Used for the choice of 'b'. Currently one of:
\itemize{
\item "JAB": this choice of b produces Jeffery's approximate BF (Wagenmakers, 2022)
\item "min": uses the minimal training sample for the prior (Gu et al., 2018)
\item "robust": a robust version of "min" that prevents too small b (O'Hagan, 1995)
\item "balanced": this choice of b balances the type I and type II errors (Gu et al, 2016)
}}

\item{upper}{The upper limit for the range of realistic effect sizes. Only relevant when method="balanced". Defaults to 1 such that the range of realistic effect sizes is uniformly distributed between 0 and 1, U(0,1).}
}
\value{
A numeric value for the BF in favour of H1.
}
\description{
Transforms a t-statistic into Jeffreys' approximate Bayes factor
}
\examples{
# Transform a t-statistic of 2.695 computed based on a sample size of 200 into JAB
JABt(200, 2.695)
}
