% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simGLM.R
\name{simGLM}
\alias{simGLM}
\title{Generate an artificial data set for some GLM's with two-way fixed effects}
\usage{
simGLM(n = NULL, t = NULL, seed = NULL, model = c("logit", "poisson", "gamma"))
}
\arguments{
\item{n}{a strictly positive integer equal to the number of cross-sectional units.}

\item{t}{a strictly positive integer equal to the number of time periods.}

\item{seed}{a seed to ensure reproducibility.}

\item{model}{a string equal to \code{"logit"}, \code{"poisson"}, or \code{"gamma"}. Default is 
\code{"logit"}.}
}
\value{
The function \code{\link{simGLM}} returns a data.frame with 6 variables.
}
\description{
Constructs an artificial data set with \eqn{n} cross-sectional units observed for \eqn{t} time
periods for logit, poisson, or gamma models. The \dQuote{true} linear predictor
(\eqn{\boldsymbol{\eta}}{\eta}) is generated as follows:
\deqn{\eta_{it} = \mathbf{x}_{it}^{\prime} \boldsymbol{\beta} +
 \alpha_{i} + \gamma_{t} \, ,}{\eta = X \beta + \alpha + 
 \gamma,}
where \eqn{\mathbf{X}}{X} consists of three independent standard normally distributed regressors.
Both parameter refering to the unobserved heterogeneity (\eqn{\alpha_{i}}{\alpha} and 
\eqn{\gamma_{t}}{\gamma}) are generated as iid. standard normal and the structural parameters are
set to \eqn{\boldsymbol{\beta} = [1, - 1, 1]^{\prime}}{\beta = [1, - 1, 1]'}.

\strong{Note:} The poisson and gamma model are based on the logarithmic link function.
}
\seealso{
\code{\link{feglm}}
}
