% Generated by roxygen2 (4.0.1): do not edit by hand
\name{teshape}
\alias{teshape}
\title{Interconvert data structures}
\usage{
teshape(data, out = c("freq", "tab", "raw"))
}
\arguments{
\item{data}{a data frame or array}

\item{out}{the output format, see examples}
}
\value{
a matrix containing the Markov basis as its columns (for easy addition to tables)
}
\description{
Interconvert an array, a raw data frame, and frequency distribution data.frame.
}
\details{
Multivariate categorical data can be represented in several ways.  Three comon ways are : a contingency table, a data frame of raw observations (1 row = 1 subject), and a long data frame with a variable containing the counts in the contingency table.
}
\examples{
data(Titanic)

# array to others
teshape(Titanic, "freq")
teshape(Titanic, "tab") # what it was
teshape(Titanic, "raw")


# freq to others
TitanicFreq <- teshape(Titanic, "freq")
teshape(TitanicFreq, "freq") # what it was
teshape(TitanicFreq, "tab")  # == Titanic
teshape(TitanicFreq, "raw")

# raw to others
TitanicRaw <- teshape(Titanic, "raw")
teshape(TitanicRaw, "freq")
teshape(TitanicRaw, "tab")
teshape(TitanicRaw, "raw")
}

