% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Classes.R
\docType{class}
\name{AbundanceCurve-class}
\alias{AbundanceCurve-class}
\alias{AbundanceCurve}
\alias{print,AbundanceCurve-method}
\alias{AbundanceCurve-method}
\alias{plot,AbundanceCurve,missing-method}
\alias{AbundanceCurve-method}
\title{S4 class defining a clonal abundance curve}
\usage{
\S4method{print}{AbundanceCurve}(x)

\S4method{plot}{AbundanceCurve,missing}(x, y, ...)
}
\arguments{
\item{x}{AbundanceCurve object}

\item{y}{ignored.}

\item{...}{arguments to pass to \link{plotDiversityCurve}.}
}
\description{
\code{AbundanceCurve} defines clonal abundance values.
}
\section{Slots}{

\describe{
\item{\code{data}}{data.frame with relative clonal abundance data and confidence intervals,
containing the following columns:
\itemize{
  \item  \code{GROUP}:  group identifier.
  \item  \code{CLONE}:  clone identifier.
  \item  \code{P}:      relative abundance of the clone.
  \item  \code{LOWER}:  lower confidence inverval bound.
  \item  \code{UPPER}:  upper confidence interval bound.
  \item  \code{RANK}:   the rank of the clone abundance.
}}

\item{\code{groups}}{character vector of group values.}

\item{\code{n}}{numeric vector indication the number of sequences in each group.}

\item{\code{nboot}}{number of bootstrap realizations performed.}

\item{\code{ci}}{confidence interval defining the upper and lower bounds 
(a value between 0 and 1).}
}}

