% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Interface.R
\name{write_airr}
\alias{write_airr}
\alias{write_rearrangement}
\alias{write_alignment}
\title{Write an AIRR TSV}
\usage{
write_airr(data, file, base = c("0", "1"), schema = RearrangementSchema,
  ...)

write_rearrangement(data, file, base = c("0", "1"), ...)

write_alignment(data, file, base = c("0", "1"), ...)
}
\arguments{
\item{data}{data.frame of Rearrangement data.}

\item{file}{output file name.}

\item{base}{starting index for positional fields in the output file. 
If \code{"0"}, then fields ending in \code{_start} and \code{_end}
will be converted to 0-based half-open intervals (python style) 
in the output file. If \code{"1"}, then these fields will not be 
modified. Fields in the input \code{data} are assumed to be 
1-based closed-intervals (R style).}

\item{schema}{\code{Schema} object defining the output format.}

\item{...}{additional arguments to pass to \link[readr]{write_delim}.}
}
\description{
\code{write_airr} writes a TSV containing AIRR formatted records.
}
\details{
\code{write_rearrangement} writes a data.frame containing AIRR Rearrangement data to TSV.

\code{write_alignment} writes a data.frame containing AIRR Alignment data to TSV.
}
\examples{
# Get path to the rearrangement-example file
file <- system.file("extdata", "rearrangement-example.tsv.gz", package="airr")

# Load data file
df <- read_rearrangement(file)

# Write a Rearrangement data file
outfile <- file.path(tempdir(), "output.tsv")
write_rearrangement(df, outfile)

}
\seealso{
See \link{Schema} for the AIRR schema object definition.
See \link{read_airr} for reading to AIRR files.
}
