% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_archives.R
\name{download_24hr_average}
\alias{download_24hr_average}
\title{Download archives of the 24 hour averages of pollutants}
\usage{
download_24hr_average(type, year, progress = interactive())
}
\arguments{
\item{type}{type of data to download.
\itemize{
 \item SO2 - Sulfur Dioxide (parts per billion)
 \item PS - Suspended solids
}}

\item{year}{a numeric vector containing the years for which to download data
(the earliest possible value is 1986 for SO2 and 1995 for PS)}

\item{progress}{whether to display a progress bar (TRUE or FALSE).
By default it will only display in an interactive session.}
}
\value{
A data.frame with pollution data.
}
\description{
Data comes from
\href{http://www.aire.cdmx.gob.mx/aire/default.php?opc=\%27aKBhnmI=\%27&opcion=ag==}{Promedios de 24 horas de partículas suspendidas(PM10 Y PM2.5)} and
\href{http://www.aire.cdmx.gob.mx/aire/default.php?opc=\%27aKBhnmI=\%27&opcion=aQ==}{Promedios de 24 horas de Dióxido azufre}
}
\examples{
\dontrun{
head(download_24hr_average("PS", 2017))
}
}
