% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformer_longformer.R
\name{train_tune_longformer_model}
\alias{train_tune_longformer_model}
\title{Function for training and fine-tuning a Longformer model}
\usage{
train_tune_longformer_model(
  ml_framework = aifeducation_config$get_framework()$TextEmbeddingFramework,
  output_dir,
  model_dir_path,
  raw_texts,
  p_mask = 0.15,
  val_size = 0.1,
  n_epoch = 1,
  batch_size = 12,
  chunk_size = 250,
  full_sequences_only = FALSE,
  min_seq_len = 50,
  learning_rate = 0.03,
  n_workers = 1,
  multi_process = FALSE,
  sustain_track = TRUE,
  sustain_iso_code = NULL,
  sustain_region = NULL,
  sustain_interval = 15,
  trace = TRUE,
  keras_trace = 1
)
}
\arguments{
\item{ml_framework}{\code{string} Framework to use for training and inference.
\code{ml_framework="tensorflow"} for 'tensorflow' and \code{ml_framework="pytorch"}
for 'pytorch'.}

\item{output_dir}{\code{string} Path to the directory where the final model
should be saved. If the directory does not exist, it will be created.}

\item{model_dir_path}{\code{string} Path to the directory where the original
model is stored.}

\item{raw_texts}{\code{vector} containing the raw texts for training.}

\item{p_mask}{\code{double} Ratio determining the number of words/tokens for masking.}

\item{val_size}{\code{double} Ratio determining the amount of token chunks used for
validation.}

\item{n_epoch}{\code{int} Number of epochs for training.}

\item{batch_size}{\code{int} Size of batches.}

\item{chunk_size}{\code{int} Size of every chunk for training.}

\item{full_sequences_only}{\code{bool} \code{TRUE} for using only chunks
with a sequence length equal to \code{chunk_size}.}

\item{min_seq_len}{\code{int} Only relevant if \code{full_sequences_only=FALSE}.
Value determines the minimal sequence length for inclusion in training process.}

\item{learning_rate}{\code{bool} Learning rate for adam optimizer.}

\item{n_workers}{\code{int} Number of workers. Only relevant if \code{ml_framework="tensorflow"}.}

\item{multi_process}{\code{bool} \code{TRUE} if multiple processes should be activated.
Only relevant if \code{ml_framework="tensorflow"}.}

\item{sustain_track}{\code{bool} If \code{TRUE} energy consumption is tracked
during training via the python library codecarbon.}

\item{sustain_iso_code}{\code{string} ISO code (Alpha-3-Code) for the country. This variable
must be set if sustainability should be tracked. A list can be found on
Wikipedia: \url{https://en.wikipedia.org/wiki/List_of_ISO_3166_country_codes}.}

\item{sustain_region}{Region within a country. Only available for USA and
Canada See the documentation of codecarbon for more information.
\url{https://mlco2.github.io/codecarbon/parameters.html}}

\item{sustain_interval}{\code{integer} Interval in seconds for measuring power
usage.}

\item{trace}{\code{bool} \code{TRUE} if information on the progress should be printed
to the console.}

\item{keras_trace}{\code{int} \code{keras_trace=0} does not print any
information about the training process from keras on the console.
\code{keras_trace=1} prints a progress bar. \code{keras_trace=2} prints
one line of information for every epoch.
Only relevant if \code{ml_framework="tensorflow"}.}
}
\value{
This function does not return an object. Instead the trained or fine-tuned
model is saved to disk.
}
\description{
This function can be used to train or fine-tune a transformer
based on Longformer architecture with the help of the python libraries 'transformers',
'datasets', and 'tokenizers'.
}
\note{
Pre-Trained models which can be fine-tuned with this function are available
at \url{https://huggingface.co/}. New models can be created via the function
\link{create_roberta_model}.

Training of this model makes use of dynamic masking.
}
\references{
Beltagy, I., Peters, M. E., & Cohan, A. (2020). Longformer: The
Long-Document Transformer. \doi{10.48550/arXiv.2004.05150}

Hugging Face Documentation
\url{https://huggingface.co/docs/transformers/model_doc/longformer#transformers.LongformerConfig}
}
\seealso{
Other Transformer: 
\code{\link{create_bert_model}()},
\code{\link{create_deberta_v2_model}()},
\code{\link{create_funnel_model}()},
\code{\link{create_longformer_model}()},
\code{\link{create_roberta_model}()},
\code{\link{train_tune_bert_model}()},
\code{\link{train_tune_deberta_v2_model}()},
\code{\link{train_tune_funnel_model}()},
\code{\link{train_tune_roberta_model}()}
}
\concept{Transformer}
