% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_S3_methods.R
\name{plot.smaAgri}
\alias{plot.smaAgri}
\title{Plot an object of class \code{smaAgri}}
\usage{
\method{plot}{smaAgri}(
  x,
  type = c("summary", "correlation", "spatial"),
  filter_traits = NULL,
  nudge_y_cv = 3,
  nudge_y_h2 = 0.07,
  horizontal = FALSE,
  theme_size = 15,
  axis_size = 8,
  text_size = 4,
  ...
)
}
\arguments{
\item{x}{An object inheriting from class \code{smaAgri} resulting of
executing the function \code{single_trial_analysis()}}

\item{type}{A character string specifiying the type of plot. "summary",
"correlation" or "spatial".}

\item{filter_traits}{An optional character vector to filter traits.}

\item{nudge_y_cv}{Vertical adjustment to nudge labels by when plotting CV
bars. Only works if the argument type is "summary". 3 by default.}

\item{nudge_y_h2}{Vertical adjustment to nudge labels by when plotting h2
bars. Only works if the argument type is "summary". 0.07 by default.}

\item{horizontal}{If \code{FALSE}, the default, the labels are plotted
vertically. If \code{TRUE}, the labels are plotted horizontally.}

\item{theme_size}{Base font size, given in pts. 15 by default.}

\item{axis_size}{Numeric input to define the axis size.}

\item{text_size}{Numeric input to define the text size.}

\item{...}{Further graphical parameters. For future improvements.}
}
\value{
A ggplot object.
}
\description{
Create several plots for an object of class \code{smaAgri}
}
\examples{
\donttest{
library(agridat)
library(agriutilities)
data(besag.met)
dat <- besag.met
results <- check_design_met(
  data = dat,
  genotype = "gen",
  trial = "county",
  traits = c("yield"),
  rep = "rep",
  block = "block",
  col = "col",
  row = "row"
)
out <- single_trial_analysis(results, progress = FALSE)
print(out)
plot(out, type = "summary", horizontal = TRUE)
plot(out, type = "correlation")
plot(out, type = "spatial")
}
}
\author{
Johan Aparicio [aut]
}
