% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{plot_fieldhub}
\alias{plot_fieldhub}
\title{Plot FielDHub Design}
\usage{
plot_fieldhub(
  design,
  x = "COLUMN",
  y = "ROW",
  labels = "PLOT",
  factor_name = "TREATMENT",
  width = 1,
  height = 1,
  space_width = 0.95,
  space_height = 0.85,
  reverse_y = FALSE,
  reverse_x = FALSE,
  shift_x = 0,
  shift_y = 0
)
}
\arguments{
\item{design}{outdesign from \code{FielDHub} package with on of the following IDs: c(9,13,14,15,16)}

\item{x}{Describes the x coordinates of a experiment design}

\item{y}{Describes the y coordinates of a experiment design}

\item{labels}{string Describes the column from that the plots are taken to display them}

\item{factor_name}{string Which factor should be used for plotting, needs to be a column in outdesign$book}

\item{width}{numeric value, describes the width of a plot in an experiment}

\item{height}{numeric value, describes the height of a plot in an experiment}

\item{space_width}{numeric value, describes the share of the space of the plots. 0=only space, 1=no space between plots in term of width}

\item{space_height}{numeric value, describes the share of the space of the plots. 0=only space, 1=no space between plots in term of height}

\item{reverse_y}{boolean, should the plots of the experiment be changed in reverse order in Row direction? use reverse_y=TRUE to have same sketch as in agricolae. default:reverse_y=FALSE}

\item{reverse_x}{boolean, should the plots of the experiment be changed in reverse order in column direction? default:reverse_x=FALSE}

\item{shift_x}{numeric indicates the shift in units in x-axis.}

\item{shift_y}{numeric indicates the shift in units for the y-axis.}
}
\value{
\code{ggplot} graphic that can be modified, if wished
}
\description{
Plots designs from \code{FielDHub} package
}
\examples{
\dontrun{
library(agricolaeplotr)
library(FielDHub)
H <- paste("H", 1:4, sep = "")
V <- paste("V", 1:5, sep = "")

strip1 <- FielDHub::strip_plot(Hplots = H,
                              Vplots = V,
                              b = 1,
                              l = 1,
                              plotNumber = 101,
                              planter = "serpentine",
                              locationNames = "A",
                              seed = 333)


strip1$fieldBook$ROW <- as.numeric(ordered(strip1$fieldBook$VSTRIP,
                       levels = unique(strip1$fieldBook$VSTRIP)))
strip1$fieldBook$COLUMN <- as.numeric(ordered(strip1$fieldBook$HSTRIP,
                       levels = unique(strip1$fieldBook$HSTRIP)))

plot_fieldhub(strip1,
              x = "ROW",
              y = "COLUMN",
              labels = "HSTRIP",
              factor_name = "HSTRIP",
              width = 12,
              height = 10,
              reverse_y = FALSE,
              reverse_x = FALSE)

}

}
