% Generated by roxygen2 (4.0.1): do not edit by hand
\name{index_rp}
\alias{index.rp}
\alias{index_rp}
\title{The r_p-index}
\usage{
index_rp(x, p = Inf)

index.rp(x, p = Inf) # same as index_rp(x, p), deprecated alias
}
\arguments{
\item{x}{a non-negative numeric vector}

\item{p}{index order, \eqn{p \in [1,\infty]}{p in [1,\infty]}; defaults \eqn{\infty} (\code{Inf}).}
}
\value{
a single numeric value
}
\description{
Given a sequence of \eqn{n} non-negative numbers \eqn{x=(x_1,\dots,x_n)},
where \eqn{x_i \ge x_j} for \eqn{i \le j},
the \dfn{\eqn{r_p}-index} for \eqn{p=\infty} equals to
\deqn{r_p(x)=\max_{i=1,\dots,n} \{ \min\{i,x_i\} \}}{
r_p(x) = max{ min{i, x_i} } for i=1,\dots,n}
if \eqn{n \ge 1}, or \eqn{r_\infty(x)=0} otherwise.
That is, it is equivalent to a particular OWMax operator,
see \code{\link{owmax}}.

For the definition of the \eqn{r_p}-index for \eqn{p < \infty} we refer
to (Gagolewski, Grzegorzewski, 2009).
}
\details{
Note that if \eqn{x_1,\dots,x_n} are integers, then
\deqn{r_\infty(x)=H(x),} where \eqn{H} is the \eqn{h}-index (Hirsch, 2005) and
\deqn{r_1(x)=W(x),} where \eqn{W} is the \eqn{w}-index (Woeginger, 2008),
see \code{\link{index_h}} and \code{\link{index_w}}.

If non-increasingly sorted vector is given, the function is O(n).

For historical reasons, this function is also available via its alias, \code{index.rp}
 [but its usage is deprecated].
}
\examples{
x <- runif(100, 0, 100);
index.rp(x);            # the r_oo-index
floor(index.rp(x));     # the h-index
index.rp(floor(x), 1);  # the w-index
}
\references{
Gagolewski M., Grzegorzewski P., A geometric approach to the construction
of scientific impact indices, Scientometrics, 81(3), 2009, pp. 617-634.\cr
Hirsch J.E., An index to quantify individual's scientific research output,
Proceedings of the National Academy of Sciences 102(46), 16569-16572, 2005.\cr
Woeginger G.J., An axiomatic characterization of the Hirsch-index,
Mathematical Social Sciences, 56(2), 224-232, 2008.\cr
}
\seealso{
Other impact_functions: \code{\link{index.g}},
  \code{\link{index_g}}, \code{\link{index_g_zi}};
  \code{\link{index.h}}, \code{\link{index_h}};
  \code{\link{index.lp}}, \code{\link{index_lp}};
  \code{\link{index_maxprod}}; \code{\link{index_w}}
}

