% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00-misc-support-functions.R
\name{default_control_tmb}
\alias{default_control_tmb}
\title{Default control arguments for \code{aghq::marginal_laplace_tmb()}.}
\usage{
default_control_tmb(...)
}
\arguments{
\item{...}{You can provide a named value for any control parameter and its
value will be set accordingly. See \code{?marginal_laplace} and examples here.}
}
\value{
A list of argument values.
}
\description{
Run \code{default_control_marglaplace()} to print the list of valid control parameters
and their defaults, and run with named arguments to change the defaults.
}
\details{
Valid options are:
\itemize{
\item{\code{method}: }{optimization method to use for the \code{theta} optimization:
\itemize{
\item{'BFGS' (default): }{\code{optim(...,method = "BFGS")}}
\item{'sparse_trust': }{\code{trustOptim::trust.optim}}
\item{'SR1': }{\code{trustOptim::trust.optim} with \code{method = 'SR1'}}
\item{'sparse': }{\code{trust::trust}}
}
}
\item \code{negate}: {default \code{TRUE}. Assumes that your \code{TMB} function
template computes the \strong{negated} log-posterior, which it must if you're using \code{TMB}'s automatic
Laplace approximation, which you must be if you're using this function!}.
\item \code{interpolation}: how to interpolate the marginal posteriors. The \code{'auto'} option
(default) chooses for you and should always work well. The \code{'polynomial'}
option uses \code{polynom::poly.calc()} to construct a global polynomial interpolant
and has been observed to be unstable as the number of quadrature points gets larger, which
is obviously a bad thing. Try \code{'spline'} instead, which uses a cubic B-Spline
interpolant from \code{splines::interpSpline()}.
\item{numhessian}: logical, default \code{TRUE}. Replace the \code{ff$he} with a numerically-differentiated
version, by calling \code{numDeriv::jacobian} on \code{ff$gr}. Used mainly for \code{TMB} with the automatic
Laplace approximation, which does not have an automatic Hessian.
\item{onlynormconst}: logical, default \code{FALSE}. Skip everything after the calculation of the log integral,
and just return the numeric value of the log integral. Saves computation time, and most useful in cases
where \code{aghq} is being used as a step in a more complicated procedure.
}
}
\examples{

default_control_marglaplace()
default_control_marglaplace(method = "trust")
default_control_marglaplace(method = "trust",inner_method = "trust")
default_control_marglaplace(negate = TRUE)

}
