% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{summary.afttest}
\alias{summary.afttest}
\title{summary.afttest}
\usage{
\method{summary}{afttest}(object, ...)
}
\arguments{
\item{object}{is a \code{afttest} fit.}

\item{...}{other options.}
}
\value{
\code{summary.afttest} returns a summary of a \code{afttest} fit:
}
\description{
summary.afttest
}
\examples{
datgen <- function(n = 100) {
  z1 <- rbinom(n, 1, 0.5)
  z2 <- rnorm(n)
  e <- rnorm(n)
  tt <- exp(2 + z1 + z2 + 0.5*z2^{2}+ e)
  cen <- runif(n, 0, 100)
  data.frame(Time = pmin(tt, cen), status = 1 * (tt < cen),
             z1 = z1, z2 = z2, id = 1:n)
}
set.seed(1)
simdata = datgen(300)

# linApprox = TRUE
result = afttest(object = Surv(Time, status) ~ z1 + z2, data = simdata,
                 npath = 100, testType = "covForm", estMethod = "rr",
                 eqType = "ns", covTested = "z2", npathsave = 50,
                 linApprox = TRUE, seed = 1)
result$p_value
result$p_std_value
print(result)
summary(result)
plot(result, std = FALSE)
plot(result, std = TRUE)

# result = afttest(object = Surv(Time, status) ~ z1 + z2, data = simdata,
#                  npath = 100, testType = "covForm", estMethod = "rr",
#                  eqType = "is", covTested = "z2", npathsave = 50,
#                  linApprox = TRUE, seed = 1)
# result$p_value
# result$p_std_value
# print(result)
# summary(result)
# plot(result, std = FALSE)
# plot(result, std = TRUE)
#
# result = afttest(object = Surv(Time, status) ~ z1 + z2, data = simdata,
#                  npath = 100, testType = "covForm", estMethod = "ls",
#                  eqType = "ls", covTested = "z2", npathsave = 50,
#                  linApprox = TRUE, seed = 1)
# result$p_value
# result$p_std_value
# print(result)
# summary(result)
# plot(result, std = FALSE)
# plot(result, std = TRUE)
#
# # linApprox = FALSE
# result = afttest(object = Surv(Time, status) ~ z1 + z2, data = simdata,
#                  npath = 100, testType = "covForm", estMethod = "rr",
#                  eqType = "ns", covTested = "z2", npathsave = 50,
#                  linApprox = FALSE, seed = 1)
# result$p_value
# result$p_std_value
# print(result)
# summary(result)
# plot(result, std = FALSE)
# plot(result, std = TRUE)
#
# result = afttest(object = Surv(Time, status) ~ z1 + z2, data = simdata,
#                  npath = 100, testType = "covForm", estMethod = "rr",
#                  eqType = "is", covTested = "z2", npathsave = 50,
#                  linApprox = FALSE, seed = 1)
# result$p_value
# result$p_std_value
# print(result)
# summary(result)
# plot(result, std = FALSE)
# plot(result, std = TRUE)
#
# result = afttest(object = Surv(Time, status) ~ z1 + z2, data = simdata,
#                  npath = 100, testType = "covForm", estMethod = "ls",
#                  eqType = "ls", covTested = "z2", npathsave = 50,
#                  linApprox = FALSE, seed = 1)
# result$p_value
# result$p_std_value
# print(result)
# summary(result)
# plot(result, std = FALSE)
# plot(result, std = TRUE)
}
